/*
 * Decompiled with CFR 0.152.
 */
package com.castortech.mdbxjni;

import com.castortech.mdbxjni.Constants;
import com.castortech.mdbxjni.Database;
import com.castortech.mdbxjni.DatabaseConfig;
import com.castortech.mdbxjni.EnvConfig;
import com.castortech.mdbxjni.EnvInfo;
import com.castortech.mdbxjni.JNI;
import com.castortech.mdbxjni.MDBXException;
import com.castortech.mdbxjni.NativeBuffer;
import com.castortech.mdbxjni.NativeObject;
import com.castortech.mdbxjni.SecondaryDatabase;
import com.castortech.mdbxjni.SecondaryDbConfig;
import com.castortech.mdbxjni.Stat;
import com.castortech.mdbxjni.Transaction;
import com.castortech.mdbxjni.Util;
import com.castortech.mdbxjni.Value;
import java.io.Closeable;
import java.util.Comparator;
import org.fusesource.hawtjni.runtime.Callback;

public class Env
extends NativeObject
implements Closeable {
    private Callback keyCmpCallback = null;
    private Callback dataCmpCallback = null;
    private Comparator<byte[]> keyComparator;
    private Comparator<byte[]> dataComparator;

    public static String version() {
        return "" + JNI.MDBX_VERSION_MAJOR + JNI.MDBX_VERSION_MINOR;
    }

    public Env(String path) {
        super(Env.create());
        this.setMaxDbs(1L);
        this.open(path);
    }

    public Env() {
        super(Env.create());
        this.setMaxDbs(1L);
    }

    private static long create() {
        long[] envPtr = new long[1];
        Util.checkErrorCode(null, JNI.mdbx_env_create(envPtr));
        return envPtr[0];
    }

    public void open(String path) {
        this.open(path, 0);
    }

    public void open(String path, int flags) {
        this.open(path, flags, 420);
    }

    public void open(String path, int flags, int mode) {
        int rc = JNI.mdbx_env_open(this.pointer(), path, flags, mode);
        if (rc != 0) {
            this.close();
        }
        Util.checkErrorCode(this, rc);
    }

    public void open(String path, EnvConfig config) {
        Util.checkArgNotNull(config, "config");
        int flags = 0;
        if (config.isNoSubDir()) {
            flags |= Constants.NOSUBDIR;
        }
        if (config.isReadOnly()) {
            flags |= Constants.RDONLY;
        }
        if (config.isExclusive()) {
            flags |= Constants.EXCLUSIVE;
        }
        if (config.isAccede()) {
            flags |= Constants.ACCEDE;
        }
        if (config.isWriteMap()) {
            flags |= Constants.WRITEMAP;
        }
        if (config.isNoTLS()) {
            flags |= Constants.NOTLS;
        }
        if (config.isNoReadAhead()) {
            flags |= Constants.NORDAHEAD;
        }
        if (config.isNoMemInit()) {
            flags |= Constants.NOMEMINIT;
        }
        if (config.isCoalesce()) {
            flags |= Constants.COALESCE;
        }
        if (config.isLifoReclaim()) {
            flags |= Constants.LIFORECLAIM;
        }
        if (config.isPagePerturb()) {
            flags |= Constants.PAGEPERTURB;
        }
        if (config.isSyncDurable()) {
            flags |= Constants.SYNCDURABLE;
        }
        if (config.isNoMetaSync()) {
            flags |= Constants.NOMETASYNC;
        }
        if (config.isSafeNoSync()) {
            flags |= Constants.SAFENOSYNC;
        }
        if (config.isMapAsync()) {
            flags |= Constants.MAPASYNC;
        }
        if (config.isUtterlyNoSync()) {
            flags |= Constants.UTTERLY_NOSYNC;
        }
        if (config.getMaxDbs() != -1L) {
            this.setMaxDbs(config.getMaxDbs());
        }
        if (config.getMaxReaders() != -1) {
            this.setMaxReaders(config.getMaxReaders());
        }
        this.setGeometry(config.getMapLower(), config.getMapSize(), config.getMapUpper(), config.getMapGrowth(), config.getMapShrink(), config.getPageSize());
        int rc = JNI.mdbx_env_open(this.pointer(), path, flags, config.getMode());
        Util.checkErrorCode(this, rc);
    }

    @Override
    public void close() {
        if (this.self != 0L) {
            JNI.mdbx_env_close(this.self);
            this.self = 0L;
        }
        if (this.keyCmpCallback != null) {
            this.keyCmpCallback.dispose();
            this.keyCmpCallback = null;
        }
        if (this.dataCmpCallback != null) {
            this.dataCmpCallback.dispose();
            this.dataCmpCallback = null;
        }
    }

    public void copy(String path) {
        this.copy(path, JNI.MDBX_CP_DEFAULTS);
    }

    public void copy(String path, int flags) {
        Util.checkArgNotNull(path, "path");
        Util.checkErrorCode(this, JNI.mdbx_env_copy(this.pointer(), path, flags));
    }

    public void sync() {
        Util.checkErrorCode(this, JNI.mdbx_env_sync(this.pointer()));
    }

    public void sync(boolean force) {
        Util.checkErrorCode(this, JNI.mdbx_env_sync_ex(this.pointer(), force ? 1 : 0, 0));
    }

    public void sync(boolean force, boolean nonblock) {
        Util.checkErrorCode(this, JNI.mdbx_env_sync_ex(this.pointer(), force ? 1 : 0, nonblock ? 1 : 0));
    }

    public void syncPoll() {
        Util.checkErrorCode(this, JNI.mdbx_env_sync_poll(this.pointer()));
    }

    public void setMapSize(long size) {
        Util.checkErrorCode(this, JNI.mdbx_env_set_mapsize(this.pointer(), size));
    }

    public void setGeometry(long lower, long now, long upper, long growthStep, long shrinkThreshold, long pageSize) {
        Util.checkErrorCode(this, JNI.mdbx_env_set_geometry(this.pointer(), lower, now, upper, growthStep, shrinkThreshold, pageSize));
    }

    public long getMaxDbs() {
        long[] rc = new long[1];
        Util.checkErrorCode(this, JNI.mdbx_env_get_maxdbs(this.pointer(), rc));
        return rc[0];
    }

    public void setMaxDbs(long size) {
        Util.checkErrorCode(this, JNI.mdbx_env_set_maxdbs(this.pointer(), size));
    }

    public long getMaxReaders() {
        long[] rc = new long[1];
        Util.checkErrorCode(this, JNI.mdbx_env_get_maxreaders(this.pointer(), rc));
        return rc[0];
    }

    public void setMaxReaders(int size) {
        Util.checkErrorCode(this, JNI.mdbx_env_set_maxreaders(this.pointer(), size));
    }

    public long getMaxKeySize() {
        return JNI.mdbx_env_get_maxkeysize(this.pointer());
    }

    public int getFlags() {
        long[] flags = new long[1];
        Util.checkErrorCode(this, JNI.mdbx_env_get_flags(this.pointer(), flags));
        return (int)flags[0];
    }

    public void addFlags(int flags) {
        Util.checkErrorCode(this, JNI.mdbx_env_set_flags(this.pointer(), flags, 1));
    }

    public void removeFlags(int flags) {
        Util.checkErrorCode(this, JNI.mdbx_env_set_flags(this.pointer(), flags, 0));
    }

    public long getUserContext() {
        return JNI.mdbx_env_get_userctx(this.pointer());
    }

    public void setUserContext(NativeObject ctx) {
        if (ctx != null) {
            JNI.mdbx_env_set_userctx(this.pointer(), ctx.pointer());
        }
    }

    @Deprecated
    public EnvInfo info() {
        JNI.MDBX_envinfo rc = new JNI.MDBX_envinfo();
        JNI.mdbx_env_info(this.pointer(), rc, JNI.SIZEOF_ENVINFO);
        return new EnvInfo(rc);
    }

    public EnvInfo info(Transaction txn) {
        JNI.MDBX_envinfo rc = new JNI.MDBX_envinfo();
        JNI.mdbx_env_info_ex(this.pointer(), txn.pointer(), rc, JNI.SIZEOF_ENVINFO);
        return new EnvInfo(rc);
    }

    @Deprecated
    public Stat stat() {
        JNI.MDBX_stat rc = new JNI.MDBX_stat();
        JNI.mdbx_env_stat(this.pointer(), rc, JNI.SIZEOF_STAT);
        return new Stat(rc);
    }

    public Stat stat(Transaction txn) {
        JNI.MDBX_stat rc = new JNI.MDBX_stat();
        JNI.mdbx_env_stat_ex(this.pointer(), txn.pointer(), rc, JNI.SIZEOF_STAT);
        return new Stat(rc);
    }

    @Deprecated
    public float percentageFull() {
        Stat stat2 = this.stat();
        EnvInfo info2 = this.info();
        if (stat2.ms_psize == 0L) {
            return 0.0f;
        }
        long nbrPages = info2.getMapSize() / stat2.ms_psize;
        return (float)info2.getLastPgNo() / (float)nbrPages * 100.0f;
    }

    public float percentageFull(Transaction txn) {
        Stat stat2 = this.stat(txn);
        EnvInfo info2 = this.info(txn);
        if (stat2.ms_psize == 0L) {
            return 0.0f;
        }
        long nbrPages = info2.getMapSize() / stat2.ms_psize;
        return (float)info2.getLastPgNo() / (float)nbrPages * 100.0f;
    }

    public Transaction createTransaction() {
        return this.createTransaction(null, false);
    }

    public Transaction createTransaction(boolean readOnly) {
        return this.createTransaction(null, readOnly);
    }

    public Transaction createReadTransaction() {
        return this.createTransaction(null, true);
    }

    public Transaction createWriteTransaction() {
        return this.createTransaction(null, false);
    }

    public Transaction createTransaction(Transaction parent) {
        return this.createTransaction(parent, false);
    }

    public Transaction createTransaction(Transaction parent, boolean readOnly) {
        long[] txpointer = new long[1];
        Util.checkErrorCode(this, JNI.mdbx_txn_begin(this.pointer(), parent == null ? 0L : parent.pointer(), readOnly ? JNI.MDBX_RDONLY : 0, txpointer));
        return new Transaction(this, txpointer[0]);
    }

    public Transaction createTransaction(Transaction parent, boolean readOnly, NativeObject ctx) {
        long[] txpointer = new long[1];
        Util.checkErrorCode(this, JNI.mdbx_txn_begin_ex(this.pointer(), parent == null ? 0L : parent.pointer(), readOnly ? JNI.MDBX_RDONLY : 0, txpointer, ctx.pointer()));
        return new Transaction(this, txpointer[0]);
    }

    public Database openDatabase(Transaction tx, String name, int flags) {
        if (tx == null) {
            return this.openDatabase(name, flags);
        }
        Util.checkArgNotNull(tx, "tx");
        long[] dbi = new long[1];
        Util.checkErrorCode(this, JNI.mdbx_dbi_open(tx.pointer(), name, flags, dbi));
        return new Database(this, dbi[0], name);
    }

    public Database openDatabase(Transaction tx, String name, DatabaseConfig config) {
        Util.checkArgNotNull(config, "config");
        if (tx == null) {
            return this.openDatabase(name, config);
        }
        Util.checkArgNotNull(tx, "tx");
        int flags = this.setFlags(config);
        if (config.getKeyComparator() != null || config.getDataComparator() != null) {
            return this.openDatabase(tx, name, flags, config.getKeyComparator(), config.getDataComparator());
        }
        return this.openDatabase(tx, name, flags);
    }

    public Database openDatabase() {
        return this.openDatabase(null, Constants.CREATE);
    }

    public Database openDatabase(Comparator<byte[]> keyComp, Comparator<byte[]> dataComp) {
        return this.openDatabase(null, Constants.CREATE, keyComp, dataComp);
    }

    public Database openDatabase(String name) {
        return this.openDatabase(name, Constants.CREATE);
    }

    public Database openDatabase(String name, Comparator<byte[]> keyComp, Comparator<byte[]> dataComp) {
        return this.openDatabase(name, Constants.CREATE, keyComp, dataComp);
    }

    public Database openDatabase(String name, int flags) {
        Transaction tx = this.createTransaction();
        try {
            Database database = this.openDatabase(tx, name, flags);
            return database;
        }
        finally {
            tx.commit();
        }
    }

    public Database openDatabase(String name, int flags, Comparator<byte[]> keyComp, Comparator<byte[]> dataComp) {
        Transaction tx = this.createTransaction();
        try {
            Database database = this.openDatabase(tx, name, flags, keyComp, dataComp);
            return database;
        }
        finally {
            tx.commit();
        }
    }

    public Database openDatabase(String name, DatabaseConfig config) {
        Transaction tx = this.createTransaction();
        try {
            Database database = this.openDatabase(tx, name, config);
            return database;
        }
        finally {
            tx.commit();
        }
    }

    public Database openDatabase(Transaction tx, String name, int flags, Comparator<byte[]> keyComp, Comparator<byte[]> dataComp) {
        if (tx == null) {
            return this.openDatabase(name, flags, keyComp, dataComp);
        }
        long keyCmpAddr = 0L;
        long dataCmpAddr = 0L;
        Util.checkArgNotNull(tx, "tx");
        long[] dbi = new long[1];
        if (keyComp != null) {
            this.keyCmpCallback = new Callback(this, "compareKey", 2);
            keyCmpAddr = this.keyCmpCallback.getAddress();
            this.keyComparator = keyComp;
        }
        if (dataComp != null) {
            this.dataCmpCallback = new Callback(dataComp.getClass(), "compareData", 2);
            dataCmpAddr = this.dataCmpCallback.getAddress();
            this.dataComparator = dataComp;
        }
        Util.checkErrorCode(this, JNI.mdbx_dbi_open_ex(tx.pointer(), name, flags, dbi, keyCmpAddr, dataCmpAddr));
        return new Database(this, dbi[0], name);
    }

    public long compareKey(long o1, long o2) {
        Value v1 = new Value();
        JNI.map_val(o1, v1);
        Value v2 = new Value();
        JNI.map_val(o2, v2);
        byte[] key1 = v1.toByteArray();
        byte[] key2 = v2.toByteArray();
        return this.keyComparator.compare(key1, key2);
    }

    public long compareData(long o1, long o2) {
        Value v1 = new Value();
        JNI.map_val(o1, v1);
        Value v2 = new Value();
        JNI.map_val(o2, v2);
        byte[] key1 = v1.toByteArray();
        byte[] key2 = v2.toByteArray();
        return this.dataComparator.compare(key1, key2);
    }

    public SecondaryDatabase openSecondaryDatabase(Database primary, String name) {
        return this.openSecondaryDatabase(primary, name, Constants.CREATE);
    }

    public SecondaryDatabase openSecondaryDatabase(Database primary, String name, int flags) {
        Transaction tx = this.createTransaction();
        try {
            SecondaryDatabase secondaryDatabase = this.openSecondaryDatabase(tx, primary, name, flags);
            return secondaryDatabase;
        }
        finally {
            tx.commit();
        }
    }

    public SecondaryDatabase openSecondaryDatabase(Transaction tx, Database primary, String name, int flags) {
        if (tx == null) {
            return this.openSecondaryDatabase(primary, name, flags);
        }
        Util.checkArgNotNull(tx, "tx");
        Util.checkArgNotNull(primary, "primary");
        long[] dbi = new long[1];
        Util.checkErrorCode(this, JNI.mdbx_dbi_open(tx.pointer(), name, flags, dbi));
        SecondaryDbConfig config = new SecondaryDbConfig();
        SecondaryDatabase secDb = new SecondaryDatabase(this, primary, dbi[0], name, config);
        if (this.associateDbs(tx, primary, secDb)) {
            return secDb;
        }
        throw new MDBXException("Error associating databases");
    }

    public SecondaryDatabase openSecondaryDatabase(Database primary, String name, SecondaryDbConfig config) {
        Transaction tx = this.createTransaction();
        try {
            SecondaryDatabase secondaryDatabase = this.openSecondaryDatabase(tx, primary, name, config);
            return secondaryDatabase;
        }
        finally {
            tx.commit();
        }
    }

    public SecondaryDatabase openSecondaryDatabase(Transaction tx, Database primary, String name, SecondaryDbConfig config) {
        if (tx == null) {
            return this.openSecondaryDatabase(primary, name, config);
        }
        Util.checkArgNotNull(tx, "tx");
        Util.checkArgNotNull(primary, "primary");
        Util.checkArgNotNull(config, "config");
        int flags = this.setFlags(config);
        long[] dbi = new long[1];
        Util.checkErrorCode(this, JNI.mdbx_dbi_open(tx.pointer(), name, flags, dbi));
        SecondaryDatabase secDb = new SecondaryDatabase(this, primary, dbi[0], name, config);
        if (this.associateDbs(tx, primary, secDb)) {
            return secDb;
        }
        throw new MDBXException("Error associating databases");
    }

    private boolean associateDbs(Transaction tx, Database primary, SecondaryDatabase secondary) {
        boolean succeeded = false;
        try {
            primary.associate(tx, secondary);
            succeeded = true;
        }
        catch (Throwable throwable) {
            if (!succeeded) {
                try {
                    primary.close();
                }
                catch (Throwable throwable2) {}
            }
            throw throwable;
        }
        if (!succeeded) {
            try {
                primary.close();
            }
            catch (Throwable throwable) {}
        }
        return succeeded;
    }

    public static void pushMemoryPool(int size) {
        NativeBuffer.pushMemoryPool(size);
    }

    public static void popMemoryPool() {
        NativeBuffer.popMemoryPool();
    }

    private int setFlags(DatabaseConfig config) {
        int flags = 0;
        if (config.isReverseKey()) {
            flags |= Constants.REVERSEKEY;
        }
        if (config.isDupSort()) {
            flags |= Constants.DUPSORT;
        }
        if (config.isIntegerKey()) {
            flags |= Constants.INTEGERKEY;
        }
        if (config.isDupFixed()) {
            flags |= Constants.DUPFIXED;
        }
        if (config.isIntegerDup()) {
            flags |= Constants.INTEGERDUP;
        }
        if (config.isReverseDup()) {
            flags |= Constants.REVERSEDUP;
        }
        if (config.isCreate()) {
            flags |= Constants.CREATE;
        }
        if (config.isAccede()) {
            flags |= Constants.DBACCEDE;
        }
        return flags;
    }
}

