/*
 * Decompiled with CFR 0.152.
 */
package com.castortech.mdbxjni;

import com.castortech.mdbxjni.JNI;

public class EnvInfo {
    private final Geo geo;
    private final long mapSize;
    private final long lastPgNo;
    private final long recentTxnId;
    private final long latterReaderTxnId;
    private final long selfLatterReaderTxnId;
    private final long meta0TxnId;
    private final long meta0Sign;
    private final long meta1TxnId;
    private final long meta1Sign;
    private final long meta2TxnId;
    private final long meta2Sign;
    private final long maxReaders;
    private final long numReaders;
    private final long dxbPageSize;
    private final long sysPageSize;
    private final BootId bootId;
    private final long unsyncVolume;
    private final long autosyncThreshold;
    private final long sinceSyncSeconds16dot16;
    private final long autosyncPeriodSeconds16dot16;
    private final long sinceReaderCheckSeconds16dot16;
    private final long mode;
    private final PgopStat pgopStat;

    EnvInfo(JNI.MDBX_envinfo rc) {
        this.geo = new Geo(rc.mi_geo_lower, rc.mi_geo_upper, rc.mi_geo_current, rc.mi_geo_shrink, rc.mi_geo_grow);
        this.mapSize = rc.mi_mapsize;
        this.lastPgNo = rc.mi_last_pgno;
        this.recentTxnId = rc.mi_recent_txnid;
        this.latterReaderTxnId = rc.mi_latter_reader_txnid;
        this.selfLatterReaderTxnId = rc.mi_self_latter_reader_txnid;
        this.meta0TxnId = rc.mi_meta0_txnid;
        this.meta0Sign = rc.mi_meta0_sign;
        this.meta1TxnId = rc.mi_meta1_txnid;
        this.meta1Sign = rc.mi_meta1_sign;
        this.meta2TxnId = rc.mi_meta2_txnid;
        this.meta2Sign = rc.mi_meta2_sign;
        this.maxReaders = rc.mi_maxreaders;
        this.numReaders = rc.mi_numreaders;
        this.dxbPageSize = rc.mi_dxb_pagesize;
        this.sysPageSize = rc.mi_sys_pagesize;
        Point current = new Point(rc.mi_bootid_current_x, rc.mi_bootid_current_y);
        Point meta0 = new Point(rc.mi_bootid_meta0_x, rc.mi_bootid_meta0_y);
        Point meta1 = new Point(rc.mi_bootid_meta1_x, rc.mi_bootid_meta1_y);
        Point meta2 = new Point(rc.mi_bootid_meta2_x, rc.mi_bootid_meta2_y);
        this.bootId = new BootId(current, meta0, meta1, meta2);
        this.unsyncVolume = rc.mi_unsync_volume;
        this.autosyncThreshold = rc.mi_autosync_threshold;
        this.sinceSyncSeconds16dot16 = rc.mi_since_sync_seconds16dot16;
        this.autosyncPeriodSeconds16dot16 = rc.mi_autosync_period_seconds16dot16;
        this.sinceReaderCheckSeconds16dot16 = rc.mi_since_reader_check_seconds16dot16;
        this.mode = rc.mi_mode;
        this.pgopStat = new PgopStat(rc.mi_pgop_stat_newly, rc.mi_pgop_stat_cow, rc.mi_pgop_stat_clone, rc.mi_pgop_stat_split, rc.mi_pgop_stat_merge, rc.mi_pgop_stat_spill, rc.mi_pgop_stat_unspill, rc.mi_pgop_stat_wops);
    }

    public Geo getGeo() {
        return this.geo;
    }

    public long getMapSize() {
        return this.mapSize;
    }

    public long getLastPgNo() {
        return this.lastPgNo;
    }

    public long getLastTxnId() {
        return this.recentTxnId;
    }

    public long getLatterReaderTxnId() {
        return this.latterReaderTxnId;
    }

    public long getSelfLatterReaderTxnId() {
        return this.selfLatterReaderTxnId;
    }

    public long getMeta0TxnId() {
        return this.meta0TxnId;
    }

    public long getMeta0Sign() {
        return this.meta0Sign;
    }

    public long getMeta1TxnId() {
        return this.meta1TxnId;
    }

    public long getMeta1Sign() {
        return this.meta1Sign;
    }

    public long getMeta2TxnId() {
        return this.meta2TxnId;
    }

    public long getMeta2Sign() {
        return this.meta2Sign;
    }

    public long getDxbPageSize() {
        return this.dxbPageSize;
    }

    public long getSysPageSize() {
        return this.sysPageSize;
    }

    public long getMaxReaders() {
        return this.maxReaders;
    }

    public long getNumReaders() {
        return this.numReaders;
    }

    public long getRecentTxnId() {
        return this.recentTxnId;
    }

    public BootId getBootId() {
        return this.bootId;
    }

    public long getUnsyncVolume() {
        return this.unsyncVolume;
    }

    public long getAutosyncThreshold() {
        return this.autosyncThreshold;
    }

    public long getSinceSyncSeconds16dot16() {
        return this.sinceSyncSeconds16dot16;
    }

    public long getAutosyncPeriodSeconds16dot16() {
        return this.autosyncPeriodSeconds16dot16;
    }

    public long getSinceReaderCheckSeconds16dot16() {
        return this.sinceReaderCheckSeconds16dot16;
    }

    public long getMode() {
        return this.mode;
    }

    public PgopStat getPgopStat() {
        return this.pgopStat;
    }

    public String toString() {
        return "EnvInfo [geo=" + this.geo + ", mapSize=" + this.mapSize + ", lastPgNo=" + this.lastPgNo + ", lastTxnId=" + this.recentTxnId + ", latterReaderTxnId=" + this.latterReaderTxnId + ", SelfLatterReaderTxnId=" + this.selfLatterReaderTxnId + ", meta0TxnId=" + this.meta0TxnId + ", meta0Sign=" + this.meta0Sign + ", meta1TxnId=" + this.meta1TxnId + ", meta1Sign=" + this.meta1Sign + ", meta2TxnId=" + this.meta2TxnId + ", meta2Sign=" + this.meta2Sign + ", maxReaders=" + this.maxReaders + ", numReaders=" + this.numReaders + ", dxbPageSize=" + this.dxbPageSize + ", sysPageSize=" + this.sysPageSize + ", bootId=" + this.bootId + ", unsyncVolume=" + this.unsyncVolume + ", autosyncThreshold=" + this.autosyncThreshold + ", sinceSyncSeconds16dot16=" + this.sinceSyncSeconds16dot16 + ", autosyncPeriodSeconds16dot16=" + this.autosyncPeriodSeconds16dot16 + ", sinceReaderCheckSeconds16dot16=" + this.sinceReaderCheckSeconds16dot16 + ", mode=" + this.mode + ", pgopStat=" + this.pgopStat + "]";
    }

    public class BootId {
        private final Point current;
        private final Point meta0;
        private final Point meta1;
        private final Point meta2;

        public BootId(Point current, Point meta0, Point meta1, Point meta2) {
            this.current = current;
            this.meta0 = meta0;
            this.meta1 = meta1;
            this.meta2 = meta2;
        }

        public Point getCurrent() {
            return this.current;
        }

        public Point getMeta0() {
            return this.meta0;
        }

        public Point getMeta1() {
            return this.meta1;
        }

        public Point getMeta2() {
            return this.meta2;
        }

        public String toString() {
            return "{current=" + this.current + ", meta0=" + this.meta0 + ", meta1=" + this.meta1 + ", meta2=" + this.meta2 + '}';
        }
    }

    public class Geo {
        private final long lower;
        private final long upper;
        private final long current;
        private final long shrink;
        private final long grow;

        public Geo(long lower, long upper, long current, long shrink, long grow) {
            this.lower = lower;
            this.upper = upper;
            this.current = current;
            this.shrink = shrink;
            this.grow = grow;
        }

        public long getLower() {
            return this.lower;
        }

        public long getUpper() {
            return this.upper;
        }

        public long getCurrent() {
            return this.current;
        }

        public long getShrink() {
            return this.shrink;
        }

        public long getGrow() {
            return this.grow;
        }

        public String toString() {
            return "{lower=" + this.lower + ", upper=" + this.upper + ", current=" + this.current + ", shrink=" + this.shrink + ", grow=" + this.grow + '}';
        }
    }

    public class PgopStat {
        private final long newly;
        private final long cow;
        private final long clone;
        private final long split;
        private final long merge;
        private final long spill;
        private final long unspill;
        private final long wops;

        public PgopStat(long newly, long cow, long clone, long split, long merge, long spill, long unspill, long wops) {
            this.newly = newly;
            this.cow = cow;
            this.clone = clone;
            this.split = split;
            this.merge = merge;
            this.spill = spill;
            this.unspill = unspill;
            this.wops = wops;
        }

        public long getNewly() {
            return this.newly;
        }

        public long getCow() {
            return this.cow;
        }

        public long getClone() {
            return this.clone;
        }

        public long getSplit() {
            return this.split;
        }

        public long getMerge() {
            return this.merge;
        }

        public long getSpill() {
            return this.spill;
        }

        public long getUnspill() {
            return this.unspill;
        }

        public long getWops() {
            return this.wops;
        }

        public String toString() {
            return "{newly=" + this.newly + ", cow=" + this.cow + ", clone=" + this.clone + ", split=" + this.split + ", merge=" + this.merge + ", spill=" + this.spill + ", unspill=" + this.unspill + ", wops=" + this.wops + "}";
        }
    }

    public class Point {
        private final long x;
        private final long y;

        public Point(long x, long y) {
            this.x = x;
            this.y = y;
        }

        public long getX() {
            return this.x;
        }

        public long getY() {
            return this.y;
        }

        public String toString() {
            return "{x=" + this.x + ", y=" + this.y + '}';
        }
    }
}

