/*
 * Decompiled with CFR 0.152.
 */
package com.castortech.mdbxjni;

import com.castortech.mdbxjni.JNI;
import com.castortech.mdbxjni.RamInfo;
import com.castortech.mdbxjni.Util;

public class Global {
    public long getMinPageSize() {
        return JNI.mdbx_limits_pgsize_min();
    }

    public long getMaxPageSize() {
        return JNI.mdbx_limits_pgsize_max();
    }

    public long getMinDbSize(long pageSize) {
        return JNI.mdbx_limits_dbsize_min(pageSize);
    }

    public long getMaxDbSize(long pageSize) {
        return JNI.mdbx_limits_dbsize_max(pageSize);
    }

    public long getMaxTxnSize(long pageSize) {
        return JNI.mdbx_limits_txnsize_max(pageSize);
    }

    public long getMaxKeySize(long pageSize, int flags) {
        return JNI.mdbx_limits_keysize_max(pageSize, flags);
    }

    public long getMaxValSize(long pageSize, int flags) {
        return JNI.mdbx_limits_valsize_max(pageSize, flags);
    }

    public RamInfo getSysRamInfo() {
        long[] pgSz = new long[1];
        long[] totPg = new long[1];
        long[] avPg = new long[1];
        Util.checkErrorCode(null, JNI.mdbx_get_sysraminfo(pgSz, totPg, avPg));
        return new RamInfo(pgSz[0], totPg[0], avPg[0]);
    }
}

