/*
 * Decompiled with CFR 0.152.
 */
package com.castortech.mdbxjni;

import com.castortech.mdbxjni.JNI;

public class MDBXException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    int errorCode;

    public MDBXException() {
    }

    public MDBXException(String message) {
        super(message);
    }

    public MDBXException(String message, int errorCode) {
        super(String.valueOf(message) + ",rc:" + (Status.fromStatusCode(errorCode) != null ? Status.fromStatusCode(errorCode).name() : Integer.valueOf(errorCode)));
        this.errorCode = errorCode;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorMessage() {
        Status status = Status.fromStatusCode(this.getErrorCode());
        return String.valueOf(this.getMessage()) + ",rc:" + (status != null ? status.name() : Integer.valueOf(this.getErrorCode()));
    }

    public static enum Status {
        OK(0, "OK"),
        EINVAL(JNI.MDBX_EINVAL, "Invalid Parameter"),
        EACCES(JNI.MDBX_EACCESS, "Access Denied"),
        ENODATA(JNI.MDBX_ENODATA, "Handle EOF"),
        ENOMEM(JNI.MDBX_ENOMEM, "Out of Memory"),
        EROFS(JNI.MDBX_EROFS, "File Read Only"),
        ENOSYS(JNI.MDBX_ENOSYS, "Not Supported"),
        EIO(JNI.MDBX_EIO, "Write Fault"),
        EPERM(JNI.MDBX_EPERM, "Invalid Function"),
        EINTR(JNI.MDBX_EINTR, "Cancelled"),
        KEYEXIST(JNI.MDBX_KEYEXIST, "key/data pair already exists"),
        NOTFOUND(JNI.MDBX_NOTFOUND, "key/data pair not found (EOF)"),
        PAGE_NOTFOUND(JNI.MDBX_PAGE_NOTFOUND, "Requested page not found - this usually indicates corruption"),
        CORRUPTED(JNI.MDBX_CORRUPTED, "Located page was wrong type"),
        PANIC(JNI.MDBX_PANIC, "Update of meta page failed or environment had fatal error"),
        VERSION_MISMATCH(JNI.MDBX_VERSION_MISMATCH, "DB file version mismatch with libmdbx"),
        INVALID(JNI.MDBX_INVALID, "File is not a valid MDBX file"),
        MAP_FULL(JNI.MDBX_MAP_FULL, "Environment mapsize reached"),
        DBS_FULL(JNI.MDBX_DBS_FULL, "Environment maxdbs reached"),
        READERS_FULL(JNI.MDBX_READERS_FULL, "Environment maxreaders reached"),
        TXN_FULL(JNI.MDBX_TXN_FULL, "Transaction has too many dirty pages"),
        CURSOR_FULL(JNI.MDBX_CURSOR_FULL, "Cursor stack too deep - internal error"),
        PAGE_FULL(JNI.MDBX_PAGE_FULL, "Page has not enough space - internal error"),
        INCOMPATIBLE(JNI.MDBX_INCOMPATIBLE, "Operation and DB incompatible, or DB type changed."),
        BAD_RSLOT(JNI.MDBX_BAD_RSLOT, "Invalid reuse of reader locktable slot"),
        BAD_TXN(JNI.MDBX_BAD_TXN, "Transaction must abort, has a child, or is invalid"),
        BAD_VALSIZE(JNI.MDBX_BAD_VALSIZE, "Unsupported size of key/DB name/data, or wrong DUPFIXED size"),
        BAD_DBI(JNI.MDBX_BAD_DBI, "The specified DBI was changed unexpectedly"),
        PROBLEM(JNI.MDBX_PROBLEM, "Unexpected problem - Transaction should abort"),
        BUSY(JNI.MDBX_BUSY, "Another write transaction is running"),
        EMULTIVAL(JNI.MDBX_EMULTIVAL, "The mdbx_put() or mdbx_replace() was called for key, that has more that one associated value."),
        BAD_SIGNATGURE(JNI.MDBX_EBADSIGN, "Bad signature of a runtime object(s), this can mean: - memory corruption or double-free; - ABI version mismatch (rare case)"),
        WANNA_RECOVERY(JNI.MDBX_WANNA_RECOVERY, "Database should be recovered, but this could NOT be done automatically right now (e.g. in readonly mode and so forth)."),
        KE_YMISMATCH(JNI.MDBX_EKEYMISMATCH, "The given key value is mismatched to the current cursor position, when mdbx_cursor_put() called with MDBX_CURRENT option."),
        TOO_LARGE(JNI.MDBX_TOO_LARGE, "Database is too large for current system, e.g. could NOT be mapped into RAM."),
        THREAD_MISMATCH(JNI.MDBX_THREAD_MISMATCH, "A thread has attempted to use a not owned object, e.g. a transaction that started by another thread."),
        RESULT_FALSE(JNI.MDBX_RESULT_FALSE, "Alias for Successful result"),
        RESULT_TRUE(JNI.MDBX_RESULT_TRUE, "Successful result with special meaning or a flag"),
        FIRST_LMDB_ERRCODE(JNI.MDBX_FIRST_LMDB_ERRCODE, "The first LMDB-compatible defined error code"),
        UNABLE_EXTEND_MAPSIZE(JNI.MDBX_UNABLE_EXTEND_MAPSIZE, "Database engine was unable to extend mapping, e.g. since address space is unavailable or busy"),
        LAST_LMDB_ERRCODE(JNI.MDBX_LAST_LMDB_ERRCODE, "The last LMDB-compatible defined error code"),
        FIRST_ADDED_ERRCODE(JNI.MDBX_FIRST_ADDED_ERRCODE, "The first of MDBX-added error codes"),
        TXN_OVERLAPPING(JNI.MDBX_TXN_OVERLAPPING, "Overlapping read and write transactions for the current thread"),
        LAST_ADDED_ERRCODE(JNI.MDBX_LAST_ADDED_ERRCODE, "The last added error code"),
        ENOFILE(JNI.MDBX_ENOFILE, "?? no description"),
        EREMOTE(JNI.MDBX_EREMOTE, "?? no description");

        private final int code;
        private final String reason;

        private Status(int statusCode, String reasonPhrase) {
            this.code = statusCode;
            this.reason = reasonPhrase;
        }

        public int getStatusCode() {
            return this.code;
        }

        public String getReasonPhrase() {
            return this.toString();
        }

        public String toString() {
            return this.reason;
        }

        public static Status fromStatusCode(int statusCode) {
            Status[] statusArray = Status.values();
            int n = statusArray.length;
            int n2 = 0;
            while (n2 < n) {
                Status s = statusArray[n2];
                if (s.code == statusCode) {
                    return s;
                }
                ++n2;
            }
            return null;
        }
    }
}

