/*
 * Decompiled with CFR 0.152.
 */
package com.castortech.mdbxjni;

import com.castortech.mdbxjni.JNI;

public final class OperationStatus {
    public static final OperationStatus SUCCESS = new OperationStatus("SUCCESS", 0);
    public static final OperationStatus KEYEXIST = new OperationStatus("KEYEXIST", JNI.MDBX_KEYEXIST);
    public static final OperationStatus NOTFOUND = new OperationStatus("NOTFOUND", JNI.MDBX_NOTFOUND);
    private String statusName;
    private int errCode;

    static OperationStatus fromInt(int errCode) {
        if (errCode == 0) {
            return SUCCESS;
        }
        if (errCode == JNI.MDBX_KEYEXIST) {
            return KEYEXIST;
        }
        if (errCode == JNI.MDBX_NOTFOUND) {
            return NOTFOUND;
        }
        throw new IllegalArgumentException("Unknown error code: " + errCode);
    }

    private OperationStatus(String statusName, int errCode) {
        this.statusName = statusName;
        this.errCode = errCode;
    }

    public String toString() {
        return "OperationStatus." + this.statusName;
    }
}

