/*
 * Decompiled with CFR 0.152.
 */
package com.castortech.mdbxjni;

import com.castortech.mdbxjni.Cursor;
import com.castortech.mdbxjni.CursorOp;
import com.castortech.mdbxjni.Database;
import com.castortech.mdbxjni.DatabaseEntry;
import com.castortech.mdbxjni.Env;
import com.castortech.mdbxjni.JNI;
import com.castortech.mdbxjni.NativeBuffer;
import com.castortech.mdbxjni.OperationStatus;
import com.castortech.mdbxjni.SecondaryDatabase;
import com.castortech.mdbxjni.Transaction;
import com.castortech.mdbxjni.Util;
import com.castortech.mdbxjni.Value;

public class SecondaryCursor
extends Cursor {
    SecondaryCursor(Env env, long self, Transaction tx, Database db) {
        super(env, self, tx, db);
    }

    @Override
    public Database getDatabase() {
        return this.getSecondaryDatabase();
    }

    public SecondaryDatabase getSecondaryDatabase() {
        return (SecondaryDatabase)super.getDatabase();
    }

    public Database getPrimaryDatabase() {
        return this.getSecondaryDatabase().getPrimaryDatabase();
    }

    public OperationStatus get(CursorOp op, DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry value) {
        Util.checkArgNotNull((Object)op, "op");
        NativeBuffer keyBuffer = NativeBuffer.create(key.getData());
        NativeBuffer pkeyBuffer = NativeBuffer.create(pKey.getData());
        try {
            Value keyValue = keyBuffer != null ? new Value(keyBuffer) : new Value();
            Value pkeyValue = pkeyBuffer != null ? new Value(pkeyBuffer) : new Value();
            int rc = JNI.mdbx_cursor_get(this.pointer(), keyValue, pkeyValue, op.getValue());
            if (rc == JNI.MDBX_NOTFOUND) {
                OperationStatus operationStatus = OperationStatus.NOTFOUND;
                return operationStatus;
            }
            Util.checkErrorCode(null, rc);
            key.setData(keyValue.toByteArray());
            pKey.setData(pkeyValue.toByteArray());
            value.setData(this.getSecondaryDatabase().getPrimaryDatabase().get(this.getTransaction(), pkeyValue));
            OperationStatus operationStatus = OperationStatus.SUCCESS;
            return operationStatus;
        }
        finally {
            if (keyBuffer != null) {
                keyBuffer.delete();
            }
            if (pkeyBuffer != null) {
                pkeyBuffer.delete();
            }
        }
    }

    @Override
    public byte[] put(byte[] key, byte[] value, int flags) {
        throw new UnsupportedOperationException();
    }
}

