/*
 * Decompiled with CFR 0.152.
 */
package com.castortech.mdbxjni;

import com.castortech.mdbxjni.CommitLatency;
import com.castortech.mdbxjni.Env;
import com.castortech.mdbxjni.JNI;
import com.castortech.mdbxjni.NativeObject;
import com.castortech.mdbxjni.TxnInfo;
import com.castortech.mdbxjni.Util;
import java.io.Closeable;

public class Transaction
extends NativeObject
implements Closeable {
    private final Env env;

    Transaction(Env env, long self) {
        super(self);
        this.env = env;
    }

    public long getId() {
        return JNI.mdbx_txn_id(this.pointer());
    }

    public void renew() {
        Util.checkErrorCode(this.env, JNI.mdbx_txn_renew(this.pointer()));
    }

    public void commit() {
        if (this.self != 0L) {
            Util.checkErrorCode(this.env, JNI.mdbx_txn_commit(this.self));
            this.self = 0L;
        }
    }

    public CommitLatency commitWithLatency() {
        if (this.self != 0L) {
            JNI.MDBX_commit_latency rc = new JNI.MDBX_commit_latency();
            Util.checkErrorCode(this.env, JNI.mdbx_txn_commit_ex(this.self, rc));
            this.self = 0L;
            return new CommitLatency(rc);
        }
        return null;
    }

    public void reset() {
        this.checkAllocated();
        JNI.mdbx_txn_reset(this.pointer());
    }

    public void abort() {
        if (this.self != 0L) {
            JNI.mdbx_txn_abort(this.self);
            this.self = 0L;
        }
    }

    public void broken() {
        Util.checkErrorCode(this.env, JNI.mdbx_txn_break(this.pointer()));
    }

    public TxnInfo info(boolean scanRlt) {
        JNI.MDBX_txn_info rc = new JNI.MDBX_txn_info();
        Util.checkErrorCode(this.env, JNI.mdbx_txn_info(this.pointer(), rc, scanRlt ? 1 : 0));
        return new TxnInfo(rc);
    }

    public int getFlags() {
        return JNI.mdbx_txn_flags(this.pointer());
    }

    public long getUserContext() {
        return JNI.mdbx_txn_get_userctx(this.pointer());
    }

    public void setUserContext(NativeObject ctx) {
        if (ctx != null) {
            JNI.mdbx_txn_set_userctx(this.pointer(), ctx.pointer());
        }
    }

    @Override
    public void close() {
        this.abort();
    }
}

