/*
 * Decompiled with CFR 0.152.
 */
package com.castortech.mdbxjni;

import com.castortech.mdbxjni.Env;
import com.castortech.mdbxjni.JNI;
import com.castortech.mdbxjni.MDBXException;
import com.castortech.mdbxjni.NativeBuffer;
import com.castortech.mdbxjni.Value;
import java.nio.charset.Charset;

class Util {
    public static final boolean isAndroid = Util.isAndroid();

    private Util() {
    }

    public static int errno() {
        return Util.errno();
    }

    public static String strerror() {
        return Util.string(JNI.strerror(Util.errno()));
    }

    public static String string(long ptr) {
        if (ptr == 0L) {
            return null;
        }
        return new String(NativeBuffer.create(ptr, JNI.strlen(ptr)).toByteArray(), Charset.defaultCharset());
    }

    public static void checkErrorCode(Env env, int rc) {
        if (rc != JNI.MDBX_SUCCESS && rc != JNI.MDBX_RESULT_TRUE) {
            String msg = Util.string(JNI.mdbx_strerror(rc));
            if (env != null) {
                System.err.println("MDBX Exception. Msg:" + msg + ", Env:" + env.info().toString());
            }
            throw new MDBXException(msg, rc);
        }
    }

    public static void checkSize(Env env, Value val) {
        long size = val.getOffendingSize(env.getMaxKeySize());
        if (size >= 0L) {
            String msg = "Key size (" + size + ") is too short or too long.";
            throw new MDBXException(msg, JNI.MDBX_BAD_VALSIZE);
        }
    }

    public static void checkArgNotNull(Object value, String name) {
        if (value == null) {
            throw new IllegalArgumentException("The " + name + " argument cannot be null");
        }
    }

    static boolean isAndroid() {
        try {
            Class.forName("android.os.Process");
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

