/*
 * Decompiled with CFR 0.152.
 */
package com.castortech.mdbxjni;

import com.castortech.mdbxjni.JNI;
import com.castortech.mdbxjni.NativeBuffer;
import java.util.Arrays;

class Value
extends JNI.MDBX_val {
    public Value() {
    }

    public Value(long data, long length) {
        this.iov_base = data;
        this.iov_len = length;
    }

    public Value(NativeBuffer buffer) {
        this(buffer.pointer(), buffer.capacity());
    }

    public static Value create(NativeBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        return new Value(buffer);
    }

    public byte[] toByteArray() {
        if (this.iov_base == 0L) {
            return null;
        }
        if (this.iov_len > Integer.MAX_VALUE) {
            throw new ArrayIndexOutOfBoundsException("Native slice is larger than the maximum Java array");
        }
        byte[] rc = new byte[(int)this.iov_len];
        JNI.buffer_copy(this.iov_base, 0L, rc, 0L, (long)rc.length);
        return rc;
    }

    public long getOffendingSize(long maxSize) {
        if (this.iov_base == 0L) {
            return 0L;
        }
        if (this.iov_len > maxSize) {
            return this.iov_len;
        }
        return -1L;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Value other = (Value)object;
        return Arrays.equals(this.toByteArray(), other.toByteArray());
    }

    public int hashCode() {
        return Arrays.hashCode(this.toByteArray());
    }
}

