/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtjni.runtime;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;

public class Library {
    public static final String STRATEGY_PROPERTY = "hawtjni.strategy";
    public static final String STRATEGY_SHA1 = "sha1";
    public static final String STRATEGY_TEMP = "temp";
    static final String SLASH = System.getProperty("file.separator");
    static final String STRATEGY = System.getProperty("hawtjni.strategy", "windows".equals(Library.getOperatingSystem()) ? "sha1" : "temp");
    private final String name;
    private final String libGroupName;
    private final String version;
    private final ClassLoader classLoader;
    private boolean loaded;
    private String nativeLibraryPath;
    private URL nativeLibrarySourceUrl;

    public Library(String name, String libGroupName) {
        this(name, libGroupName, null, null);
    }

    public Library(String name, String libGroupName, Class<?> clazz) {
        this(name, libGroupName, Library.version(clazz), clazz.getClassLoader());
    }

    public Library(String name, String libGroupName, String version) {
        this(name, libGroupName, version, null);
    }

    public Library(String name, String libGroupName, String version, ClassLoader classLoader) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        this.name = name;
        this.libGroupName = libGroupName;
        this.version = version;
        this.classLoader = classLoader;
    }

    private static String version(Class<?> clazz) {
        try {
            return clazz.getPackage().getImplementationVersion();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public String getNativeLibraryPath() {
        return this.nativeLibraryPath;
    }

    public URL getNativeLibrarySourceUrl() {
        return this.nativeLibrarySourceUrl;
    }

    public static String getOperatingSystem() {
        String name = System.getProperty("os.name").toLowerCase().trim();
        if (name.startsWith("linux")) {
            return "linux";
        }
        if (name.startsWith("mac os x")) {
            return "osx";
        }
        if (name.startsWith("win")) {
            return "windows";
        }
        return name.replaceAll("\\W+", "_");
    }

    public static String getPlatform() {
        return String.valueOf(Library.getOperatingSystem()) + Library.getBitModel();
    }

    public static int getBitModel() {
        String prop = System.getProperty("sun.arch.data.model");
        if (prop == null) {
            prop = System.getProperty("com.ibm.vm.bitmode");
        }
        if (prop != null) {
            return Integer.parseInt(prop);
        }
        String arch = System.getProperty("os.arch");
        if (arch.endsWith("64") && "Substrate VM".equals(System.getProperty("java.vm.name"))) {
            return 64;
        }
        return 64;
    }

    public synchronized void load() {
        if (this.loaded) {
            return;
        }
        this.doLoad();
        this.loaded = true;
    }

    private void doLoad() {
        int n;
        String version = System.getProperty("library." + this.name + ".version");
        if (version == null) {
            version = this.version;
        }
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        String[] specificDirs = this.getSpecificSearchDirs();
        String libFilename = this.map(this.name);
        String versionlibFilename = version == null ? null : this.map(String.valueOf(this.name) + "-" + version);
        String customPath = System.getProperty("library." + this.name + ".path");
        if (customPath != null) {
            String[] stringArray = specificDirs;
            n = specificDirs.length;
            int n2 = 0;
            while (n2 < n) {
                String dir = stringArray[n2];
                if (version != null && this.load(errors, this.file(customPath, dir, versionlibFilename))) {
                    return;
                }
                if (this.load(errors, this.file(customPath, dir, libFilename))) {
                    return;
                }
                ++n2;
            }
        }
        if (version != null && this.loadLibrary(errors, String.valueOf(this.name) + Library.getBitModel() + "-" + version)) {
            return;
        }
        if (version != null && this.loadLibrary(errors, String.valueOf(this.name) + "-" + version)) {
            return;
        }
        if (this.loadLibrary(errors, this.name)) {
            return;
        }
        if (this.classLoader != null) {
            String targetLibName = version != null ? versionlibFilename : libFilename;
            String[] stringArray = specificDirs;
            int n3 = specificDirs.length;
            n = 0;
            while (n < n3) {
                String dir = stringArray[n];
                if (version != null && this.extractAndLoad(errors, customPath, dir, versionlibFilename, targetLibName)) {
                    return;
                }
                if (this.extractAndLoad(errors, customPath, dir, libFilename, targetLibName)) {
                    return;
                }
                ++n;
            }
        }
        UnsatisfiedLinkError e = new UnsatisfiedLinkError("Could not load library. Reasons: " + errors.toString());
        try {
            Method method = Throwable.class.getMethod("addSuppressed", Throwable.class);
            for (Throwable t : errors) {
                method.invoke((Object)e, t);
            }
        }
        catch (Throwable throwable) {}
        throw e;
    }

    @Deprecated
    public final String getArchSpecifcResourcePath() {
        return this.getArchSpecificResourcePath();
    }

    public final String getArchSpecificResourcePath() {
        return "META-INF/native/" + Library.getPlatform() + "/" + System.getProperty("os.arch") + "/" + this.map(this.name);
    }

    @Deprecated
    public final String getOperatingSystemSpecifcResourcePath() {
        return this.getOperatingSystemSpecificResourcePath();
    }

    public final String getOperatingSystemSpecificResourcePath() {
        return this.getPlatformSpecificResourcePath(Library.getOperatingSystem());
    }

    @Deprecated
    public final String getPlatformSpecifcResourcePath() {
        return this.getPlatformSpecificResourcePath();
    }

    public final String getPlatformSpecificResourcePath() {
        return this.getPlatformSpecificResourcePath(Library.getPlatform());
    }

    @Deprecated
    public final String getPlatformSpecifcResourcePath(String platform) {
        return this.getPlatformSpecificResourcePath(platform);
    }

    public final String getPlatformSpecificResourcePath(String platform) {
        return "META-INF/native/" + platform + "/" + this.map(this.name);
    }

    @Deprecated
    public final String getResorucePath() {
        return this.getResourcePath();
    }

    public final String getResourcePath() {
        return "META-INF/native/" + this.map(this.name);
    }

    public final String getLibraryFileName() {
        return this.map(this.name);
    }

    public final String[] getSpecificSearchDirs() {
        return new String[]{String.valueOf(Library.getPlatform()) + "/" + System.getProperty("os.arch"), Library.getPlatform(), Library.getOperatingSystem(), "."};
    }

    private boolean extractAndLoad(ArrayList<Throwable> errors, String customPath, String dir, String libName, String targetLibName) {
        String resourcePath = "META-INF/native/" + (dir == null ? "" : String.valueOf(dir) + '/') + libName;
        URL resource = this.classLoader.getResource(resourcePath);
        if (resource != null) {
            int idx = targetLibName.lastIndexOf(46);
            String prefix = String.valueOf(targetLibName.substring(0, idx)) + "-";
            String suffix = targetLibName.substring(idx);
            for (File path : Arrays.asList(customPath != null ? this.file(customPath) : null, this.file(System.getProperty("java.io.tmpdir")), this.file(System.getProperty("user.home"), ".hawtjni", this.libGroupName != null ? this.libGroupName : this.name))) {
                File target;
                if (path == null || (target = STRATEGY_SHA1.equals(STRATEGY) ? this.extractSha1(errors, resource, prefix, suffix, path) : this.extractTemp(errors, resource, prefix, suffix, path)) == null || !this.load(errors, target)) continue;
                this.nativeLibrarySourceUrl = resource;
                return true;
            }
        }
        return false;
    }

    private File file(String ... paths) {
        File rc = null;
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            if (rc == null) {
                rc = new File(path);
            } else if (path != null) {
                rc = new File(rc, path);
            }
            ++n2;
        }
        return rc;
    }

    private String map(String libName) {
        libName = System.mapLibraryName(libName);
        String ext = ".dylib";
        return libName;
    }

    private File extractSha1(ArrayList<Throwable> errors, URL source, String prefix, String suffix, File directory) {
        File file;
        File target = null;
        if (!(directory = directory.getAbsoluteFile()).exists() && !directory.mkdirs()) {
            errors.add(new IOException("Unable to create directory: " + directory));
            return null;
        }
        String sha1 = this.computeSha1(source.openStream());
        String sha1f = "";
        File sha1Dir = new File(directory, "jar_lib_" + prefix + sha1);
        sha1Dir.mkdirs();
        target = new File(sha1Dir, String.valueOf(prefix.substring(0, prefix.length() - 1)) + suffix);
        if (target.isFile() && target.canRead()) {
            sha1f = this.computeSha1(new FileInputStream(target));
        }
        if (sha1f.equals(sha1)) {
            return target;
        }
        FileOutputStream os = null;
        InputStream is = null;
        try {
            is = source.openStream();
            if (is != null) {
                int read;
                byte[] buffer = new byte[4096];
                os = new FileOutputStream(target);
                while ((read = is.read(buffer)) != -1) {
                    os.write(buffer, 0, read);
                }
                this.chmod755(target);
            }
            file = target;
        }
        catch (Throwable throwable) {
            try {
                Library.close(os);
                Library.close(is);
                throw throwable;
            }
            catch (Throwable e) {
                IOException io;
                if (target != null) {
                    target.delete();
                    io = new IOException("Unable to extract library from " + source + " to " + target);
                } else {
                    io = new IOException("Unable to create temporary file in " + directory);
                }
                io.initCause(e);
                errors.add(io);
                return null;
            }
        }
        Library.close(os);
        Library.close(is);
        return file;
    }

    private String computeSha1(InputStream is) throws NoSuchAlgorithmException, IOException {
        String sha1;
        try {
            int read;
            MessageDigest mDigest = MessageDigest.getInstance("SHA1");
            byte[] buffer = new byte[4096];
            while ((read = is.read(buffer)) != -1) {
                mDigest.update(buffer, 0, read);
            }
            byte[] result = mDigest.digest();
            StringBuilder sb = new StringBuilder();
            byte[] byArray = result;
            int n = result.length;
            int n2 = 0;
            while (n2 < n) {
                byte b = byArray[n2];
                sb.append(Integer.toString((b & 0xFF) + 256, 16).substring(1));
                ++n2;
            }
            sha1 = sb.toString();
        }
        finally {
            Library.close(is);
        }
        return sha1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File extractTemp(ArrayList<Throwable> errors, URL source, String prefix, String suffix, File directory) {
        File target = null;
        if (!(directory = directory.getAbsoluteFile()).exists() && !directory.mkdirs()) {
            errors.add(new IOException("Unable to create directory: " + directory));
            return null;
        }
        try {
            File file;
            InputStream is;
            FileOutputStream os;
            block12: {
                os = null;
                is = null;
                target = new File(directory, String.valueOf(prefix.substring(0, prefix.length() - 1)) + suffix);
                String sha1 = this.computeSha1(source.openStream());
                String sha1f = "";
                if (target.isFile() && target.canRead()) {
                    sha1f = this.computeSha1(new FileInputStream(target));
                }
                if (!sha1f.equals(sha1)) break block12;
                File file2 = target;
                Library.close(os);
                Library.close(is);
                return file2;
            }
            try {
                is = source.openStream();
                if (is != null) {
                    byte[] buffer = new byte[4096];
                    os = new FileOutputStream(target);
                    while (true) {
                        int read;
                        if ((read = is.read(buffer)) == -1) {
                            this.chmod755(target);
                            break;
                        }
                        os.write(buffer, 0, read);
                    }
                }
                target.deleteOnExit();
                file = target;
            }
            catch (Throwable throwable) {
                Library.close(os);
                Library.close(is);
                throw throwable;
            }
            Library.close(os);
            Library.close(is);
            return file;
        }
        catch (Throwable e) {
            IOException io;
            if (target != null) {
                target.delete();
                io = new IOException("Unable to extract library from " + source + " to " + target);
            } else {
                io = new IOException("Unable to create temporary file in " + directory);
            }
            io.initCause(e);
            errors.add(io);
            return null;
        }
    }

    private static void close(Closeable file) {
        if (file != null) {
            try {
                file.close();
            }
            catch (Exception exception) {}
        }
    }

    private void chmod755(File file) {
        if (Library.getPlatform().startsWith("windows")) {
            return;
        }
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            Class<?> posixFilePermissionsClass = classLoader.loadClass("java.nio.file.attribute.PosixFilePermissions");
            Method fromStringMethod = posixFilePermissionsClass.getMethod("fromString", String.class);
            Object permissionSet = fromStringMethod.invoke(null, "rwxr-xr-x");
            Object path = file.getClass().getMethod("toPath", new Class[0]).invoke((Object)file, new Object[0]);
            Class<?> pathClass = classLoader.loadClass("java.nio.file.Path");
            Class<?> filesClass = classLoader.loadClass("java.nio.file.Files");
            Method setPosixFilePermissionsMethod = filesClass.getMethod("setPosixFilePermissions", pathClass, Set.class);
            setPosixFilePermissionsMethod.invoke(null, path, permissionSet);
        }
        catch (Throwable throwable) {
            try {
                Runtime.getRuntime().exec(new String[]{"chmod", "755", file.getCanonicalPath()}).waitFor();
            }
            catch (Throwable throwable2) {}
        }
    }

    private boolean load(ArrayList<Throwable> errors, File lib) {
        try {
            System.load(lib.getPath());
            this.nativeLibraryPath = lib.getPath();
            return true;
        }
        catch (UnsatisfiedLinkError e) {
            LinkageError le = new LinkageError("Unable to load library from " + lib);
            le.initCause(e);
            errors.add(le);
            return false;
        }
    }

    private boolean loadLibrary(ArrayList<Throwable> errors, String lib) {
        try {
            System.loadLibrary(lib);
            this.nativeLibraryPath = "java.library.path,sun.boot.library.pathlib:" + lib;
            return true;
        }
        catch (UnsatisfiedLinkError e) {
            LinkageError le = new LinkageError("Unable to load library " + lib);
            le.initCause(e);
            errors.add(le);
            return false;
        }
    }
}

