/*
 * Decompiled with CFR 0.152.
 */
package com.conversantmedia.util.concurrent;

import com.conversantmedia.util.concurrent.Condition;
import java.util.concurrent.locks.ReentrantLock;

abstract class AbstractCondition
implements Condition {
    private final ReentrantLock queueLock = new ReentrantLock();
    private final java.util.concurrent.locks.Condition condition = this.queueLock.newCondition();

    AbstractCondition() {
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void awaitNanos(long timeout) throws InterruptedException {
        long remaining = timeout;
        this.queueLock.lock();
        try {
            block6: {
                block5: {
                    if (!true) break block5;
                    if (!this.test()) return;
                    if (remaining <= 0L) break block6;
                }
                do {
                    remaining = this.condition.awaitNanos(remaining);
                    if (!this.test()) return;
                } while (remaining > 0L);
            }
            return;
        }
        finally {
            this.queueLock.unlock();
        }
    }

    @Override
    public void await() throws InterruptedException {
        this.queueLock.lock();
        try {
            while (this.test()) {
                this.condition.await();
            }
        }
        finally {
            this.queueLock.unlock();
        }
    }

    @Override
    public void signal() {
        this.queueLock.lock();
        try {
            this.condition.signalAll();
        }
        finally {
            this.queueLock.unlock();
        }
    }
}

