/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.strictmachine;

import java.util.Objects;
import java.util.StringJoiner;

public interface FsmContext<S, E> {
    public S currentState();

    public void fireEvent(E var1);

    public void shelveEvent(E var1);

    public void processShelvedEvents();

    public Object get(Key<?> var1);

    public Object remove(Key<?> var1);

    public void set(Key<?> var1, Object var2);

    public long getInstanceId();

    public static final class Key<T> {
        private final String name;
        private final Class<T> type;

        public Key(String name, Class<T> type) {
            this.name = name;
            this.type = type;
        }

        public String name() {
            return this.name;
        }

        public Class<T> type() {
            return this.type;
        }

        public T get(FsmContext<?, ?> context) {
            Object value = context.get(this);
            return value != null ? (T)this.type.cast(value) : null;
        }

        public T remove(FsmContext<?, ?> context) {
            Object value = context.remove(this);
            return value != null ? (T)this.type.cast(value) : null;
        }

        public void set(FsmContext<?, ?> context, T value) {
            context.set(this, value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return Objects.equals(this.name, key.name) && Objects.equals(this.type, key.type);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.type);
        }

        public String toString() {
            return new StringJoiner(", ", String.valueOf(Key.class.getSimpleName()) + "[", "]").add("name='" + this.name + "'").add("type=" + this.type).toString();
        }
    }
}

