/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.netty.fsm;

import com.digitalpetri.netty.fsm.Event;
import com.digitalpetri.netty.fsm.Scheduler;
import com.digitalpetri.netty.fsm.State;
import com.digitalpetri.strictmachine.Fsm;
import com.digitalpetri.strictmachine.FsmContext;
import com.digitalpetri.strictmachine.dsl.ActionContext;
import com.digitalpetri.strictmachine.dsl.FsmBuilder;
import com.digitalpetri.strictmachine.dsl.TransitionAction;
import io.netty.channel.Channel;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;

public class ChannelFsm {
    private final List<TransitionListener> transitionListeners = new CopyOnWriteArrayList<TransitionListener>();
    private final Fsm<State, Event> fsm;
    static final FsmContext.Key<ConnectFuture> KEY_CF = new FsmContext.Key("connectFuture", ConnectFuture.class);
    static final FsmContext.Key<DisconnectFuture> KEY_DF = new FsmContext.Key("disconnectFuture", DisconnectFuture.class);
    static final FsmContext.Key<Long> KEY_RD = new FsmContext.Key("reconnectDelay", Long.class);
    static final FsmContext.Key<Scheduler.Cancellable> KEY_RDF = new FsmContext.Key("reconnectDelayCancellable", Scheduler.Cancellable.class);

    ChannelFsm(FsmBuilder<State, Event> builder, State initialState) {
        builder.addTransitionAction((TransitionAction)new TransitionAction<State, Event>(){

            public void execute(ActionContext<State, Event> context) {
                ChannelFsm.this.transitionListeners.forEach(listener -> listener.onStateTransition((State)((Object)((Object)context.from())), (State)((Object)((Object)context.to())), (Event)context.event()));
            }

            public boolean matches(State from, State to, Event event) {
                return true;
            }
        });
        this.fsm = builder.build((Enum)initialState);
    }

    Fsm<State, Event> getFsm() {
        return this.fsm;
    }

    public CompletableFuture<Channel> connect() {
        Event.Connect connect = new Event.Connect();
        this.fsm.fireEvent((Object)connect);
        return connect.channelFuture;
    }

    public CompletableFuture<Void> disconnect() {
        Event.Disconnect disconnect = new Event.Disconnect();
        this.fsm.fireEvent((Object)disconnect);
        return disconnect.disconnectFuture;
    }

    public CompletableFuture<Channel> getChannel() {
        return this.getChannel(true);
    }

    public CompletableFuture<Channel> getChannel(boolean waitForReconnect) {
        CompletableFuture future = (CompletableFuture)this.fsm.getFromContext(ctx -> {
            State state = (State)((Object)((Object)ctx.currentState()));
            if (state == State.Connected) {
                ConnectFuture cf = (ConnectFuture)KEY_CF.get(ctx);
                assert (cf != null);
                return cf.future;
            }
            return null;
        });
        if (future != null) {
            return future;
        }
        Event.GetChannel getChannel = new Event.GetChannel(waitForReconnect);
        this.fsm.fireEvent((Object)getChannel);
        return getChannel.channelFuture;
    }

    public State getState() {
        return (State)((Object)this.fsm.getFromContext(FsmContext::currentState));
    }

    public void addTransitionListener(TransitionListener transitionListener) {
        this.transitionListeners.add(transitionListener);
    }

    public void removeTransitionListener(TransitionListener transitionListener) {
        this.transitionListeners.remove(transitionListener);
    }

    static class ConnectFuture {
        final CompletableFuture<Channel> future = new CompletableFuture();

        ConnectFuture() {
        }
    }

    static class DisconnectFuture {
        final CompletableFuture<Void> future = new CompletableFuture();

        DisconnectFuture() {
        }
    }

    public static interface TransitionListener {
        public void onStateTransition(State var1, State var2, Event var3);
    }
}

