/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.jsonFormatVisitors;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum JsonFormatTypes {
    STRING,
    NUMBER,
    INTEGER,
    BOOLEAN,
    OBJECT,
    ARRAY,
    NULL,
    ANY;

    private static final Map<String, JsonFormatTypes> _byLCName;

    static {
        _byLCName = new HashMap<String, JsonFormatTypes>();
        JsonFormatTypes[] jsonFormatTypesArray = JsonFormatTypes.values();
        int n = jsonFormatTypesArray.length;
        int n2 = 0;
        while (n2 < n) {
            JsonFormatTypes t = jsonFormatTypesArray[n2];
            _byLCName.put(t.name().toLowerCase(), t);
            ++n2;
        }
    }

    @JsonValue
    public String value() {
        return this.name().toLowerCase();
    }

    @JsonCreator
    public static JsonFormatTypes forValue(String s) {
        return _byLCName.get(s);
    }
}

