/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi.internal;

import com.kenai.jffi.Platform;
import com.kenai.jffi.Util;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Properties;

public class StubLoader {
    public static final int VERSION_MAJOR = StubLoader.getVersionField("MAJOR");
    public static final int VERSION_MINOR = StubLoader.getVersionField("MINOR");
    private static final String versionClassName = "com.kenai.jffi.Version";
    private static final Locale LOCALE = Locale.ENGLISH;
    private static final String bootPropertyFilename = "boot.properties";
    private static final String bootLibraryPropertyName = "jffi.boot.library.path";
    private static final String stubLibraryName = String.format("jffi-%d.%d", VERSION_MAJOR, VERSION_MINOR);
    private static final String TMPDIR_ENV = Platform.getPlatform().getOS() == Platform.OS.WINDOWS ? "TEMP" : "TMPDIR";
    private static final String TMPDIR = System.getProperty("java.io.tmpdir");
    private static final String TMPDIR_RECOMMENDATION = "Set `" + TMPDIR_ENV + "` or Java property `java.io.tmpdir` to a read/write path that is not mounted \"noexec\".";
    public static final String TMPDIR_WRITE_ERROR = "Unable to write jffi binary stub to `" + TMPDIR + "`.";
    public static final String TMPDIR_EXEC_ERROR = "Unable to execute or load jffi binary stub from `" + TMPDIR + "`.";
    private static volatile OS os = null;
    private static volatile CPU cpu = null;
    private static volatile Throwable failureCause = null;
    private static volatile boolean loaded = false;

    static {
        try {
            StubLoader.load();
            loaded = true;
        }
        catch (Throwable t) {
            failureCause = t;
        }
    }

    public static final boolean isLoaded() {
        return loaded;
    }

    public static final Throwable getFailureCause() {
        return failureCause;
    }

    private static OS determineOS() {
        String osName = System.getProperty("os.name").split(" ")[0];
        if (Util.startsWithIgnoreCase(osName, "mac", LOCALE) || Util.startsWithIgnoreCase(osName, "darwin", LOCALE)) {
            return OS.DARWIN;
        }
        if (Util.startsWithIgnoreCase(osName, "linux", LOCALE)) {
            return OS.LINUX;
        }
        if (Util.startsWithIgnoreCase(osName, "sunos", LOCALE) || Util.startsWithIgnoreCase(osName, "solaris", LOCALE)) {
            return OS.SOLARIS;
        }
        if (Util.startsWithIgnoreCase(osName, "aix", LOCALE)) {
            return OS.AIX;
        }
        if (Util.startsWithIgnoreCase(osName, "openbsd", LOCALE)) {
            return OS.OPENBSD;
        }
        if (Util.startsWithIgnoreCase(osName, "freebsd", LOCALE)) {
            return OS.FREEBSD;
        }
        if (Util.startsWithIgnoreCase(osName, "dragonfly", LOCALE)) {
            return OS.DRAGONFLY;
        }
        if (Util.startsWithIgnoreCase(osName, "windows", LOCALE)) {
            return OS.WINDOWS;
        }
        throw new RuntimeException("cannot determine operating system");
    }

    private static CPU determineCPU() {
        String archString = System.getProperty("os.arch", "unknown");
        if (Util.equalsIgnoreCase("x86", archString, LOCALE) || Util.equalsIgnoreCase("i386", archString, LOCALE) || Util.equalsIgnoreCase("i86pc", archString, LOCALE)) {
            return CPU.I386;
        }
        if (Util.equalsIgnoreCase("x86_64", archString, LOCALE) || Util.equalsIgnoreCase("amd64", archString, LOCALE)) {
            return CPU.X86_64;
        }
        if (Util.equalsIgnoreCase("ppc", archString, LOCALE) || Util.equalsIgnoreCase("powerpc", archString, LOCALE)) {
            return CPU.PPC;
        }
        if (Util.equalsIgnoreCase("ppc64", archString, LOCALE) || Util.equalsIgnoreCase("powerpc64", archString, LOCALE)) {
            if ("little".equals(System.getProperty("sun.cpu.endian"))) {
                return CPU.PPC64LE;
            }
            return CPU.PPC64;
        }
        if (Util.equalsIgnoreCase("ppc64le", archString, LOCALE) || Util.equalsIgnoreCase("powerpc64le", archString, LOCALE)) {
            return CPU.PPC64LE;
        }
        if (Util.equalsIgnoreCase("s390", archString, LOCALE) || Util.equalsIgnoreCase("s390x", archString, LOCALE)) {
            return CPU.S390X;
        }
        if (Util.equalsIgnoreCase("arm", archString, LOCALE) || Util.equalsIgnoreCase("armv7l", archString, LOCALE)) {
            return CPU.ARM;
        }
        if (Util.equalsIgnoreCase("aarch64", archString, LOCALE)) {
            return CPU.AARCH64;
        }
        CPU[] cPUArray = CPU.values();
        int n = cPUArray.length;
        int n2 = 0;
        while (n2 < n) {
            CPU cpu = cPUArray[n2];
            if (Util.equalsIgnoreCase(cpu.name(), archString, LOCALE)) {
                return cpu;
            }
            ++n2;
        }
        throw new RuntimeException("cannot determine CPU");
    }

    public static CPU getCPU() {
        return cpu != null ? cpu : (cpu = StubLoader.determineCPU());
    }

    public static OS getOS() {
        return os != null ? os : (os = StubLoader.determineOS());
    }

    private static String getStubLibraryName() {
        return stubLibraryName;
    }

    public static String getPlatformName() {
        if (StubLoader.getOS().equals((Object)OS.DARWIN)) {
            return "Darwin";
        }
        String osName = System.getProperty("os.name").split(" ")[0];
        return String.valueOf(StubLoader.getCPU().name().toLowerCase(LOCALE)) + "-" + osName;
    }

    private static String getStubLibraryPath() {
        return "jni/" + StubLoader.getPlatformName() + "/" + System.mapLibraryName(stubLibraryName);
    }

    /*
     * Unable to fully structure code
     */
    static void load() {
        block7: {
            libName = StubLoader.getStubLibraryName();
            errors = new ArrayList<Throwable>();
            bootPath = StubLoader.getBootPath();
            if (bootPath != null && StubLoader.loadFromBootPath(libName, bootPath, errors)) {
                return;
            }
            libraryPath = System.getProperty("java.library.path");
            if (libraryPath != null && StubLoader.loadFromBootPath(libName, libraryPath, errors)) {
                return;
            }
            try {
                StubLoader.loadFromJar(null);
                return;
            }
            catch (Throwable v0) {
                try {
                    StubLoader.loadFromJar(new File(System.getProperty("user.dir")));
                }
                catch (Throwable t1) {
                    errors.add(t1);
                }
                if (errors.isEmpty()) break block7;
                Collections.reverse(errors);
                caw = new CharArrayWriter();
                pw = new PrintWriter(caw);
                ** for (t : errors)
            }
lbl-1000:
            // 1 sources

            {
                t.printStackTrace(pw);
                continue;
            }
lbl26:
            // 1 sources

            throw new UnsatisfiedLinkError(new String(caw.toCharArray()));
        }
    }

    /*
     * Loose catch block
     */
    private static String getBootPath() {
        String bootPath = System.getProperty(bootLibraryPropertyName);
        if (bootPath != null) {
            return bootPath;
        }
        InputStream is = StubLoader.getResourceAsStream(bootPropertyFilename);
        if (is != null) {
            Properties p = new Properties();
            p.load(is);
            String string = p.getProperty(bootLibraryPropertyName);
            try {
                is.close();
            }
            catch (IOException iOException) {}
            return string;
            catch (IOException iOException) {
                try {}
                catch (Throwable throwable) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException2) {}
                    throw throwable;
                }
                try {
                    is.close();
                }
                catch (IOException iOException3) {}
                return null;
            }
        }
        return null;
    }

    private static String getAlternateLibraryPath(String path) {
        if (path.endsWith("dylib")) {
            return String.valueOf(path.substring(0, path.lastIndexOf("dylib"))) + "jnilib";
        }
        return String.valueOf(path.substring(0, path.lastIndexOf("jnilib"))) + "dylib";
    }

    private static boolean loadFromBootPath(String libName, String bootPath, Collection<Throwable> errors) {
        String[] dirs = bootPath.split(File.pathSeparator);
        int i = 0;
        while (i < dirs.length) {
            String soname = System.mapLibraryName(libName);
            File stub = new File(new File(dirs[i], StubLoader.getPlatformName()), soname);
            if (!stub.isFile()) {
                stub = new File(new File(dirs[i]), soname);
            }
            String path = stub.getAbsolutePath();
            if (stub.isFile()) {
                try {
                    System.load(path);
                    return true;
                }
                catch (UnsatisfiedLinkError ex) {
                    errors.add(ex);
                }
            }
            if (StubLoader.getOS() == OS.DARWIN && new File(path = StubLoader.getAlternateLibraryPath(path)).isFile()) {
                try {
                    System.load(path);
                    return true;
                }
                catch (UnsatisfiedLinkError ex) {
                    errors.add(ex);
                }
            }
            ++i;
        }
        return false;
    }

    private static String dlExtension() {
        switch (StubLoader.getOS()) {
            case WINDOWS: {
                return "dll";
            }
            case DARWIN: {
                return "dylib";
            }
        }
        return "so";
    }

    private static void loadFromJar(File tmpDirFile) throws IOException, LinkageError {
        File dstFile;
        try (InputStream is = StubLoader.getStubLibraryStream();){
            try {
                dstFile = tmpDirFile == null ? File.createTempFile("jffi", "." + StubLoader.dlExtension()) : File.createTempFile("jffi", "." + StubLoader.dlExtension(), tmpDirFile);
                dstFile.deleteOnExit();
                try (FileOutputStream os = new FileOutputStream(dstFile);){
                    ReadableByteChannel srcChannel = Channels.newChannel(is);
                    long pos = 0L;
                    while (is.available() > 0) {
                        pos += os.getChannel().transferFrom(srcChannel, pos, Math.max(4096, is.available()));
                    }
                }
            }
            catch (IOException ioe) {
                throw StubLoader.tempReadonlyError(ioe);
            }
        }
        try {
            System.load(dstFile.getAbsolutePath());
            dstFile.delete();
        }
        catch (UnsatisfiedLinkError ule) {
            throw StubLoader.tempLoadError(ule);
        }
    }

    private static IOException tempReadonlyError(IOException ioe) {
        return new IOException(String.valueOf(TMPDIR_WRITE_ERROR) + " " + TMPDIR_RECOMMENDATION, ioe);
    }

    private static UnsatisfiedLinkError tempLoadError(UnsatisfiedLinkError ule) {
        return new UnsatisfiedLinkError(String.valueOf(TMPDIR_EXEC_ERROR) + " " + TMPDIR_RECOMMENDATION + "\n" + ule.getLocalizedMessage());
    }

    private static InputStream getStubLibraryStream() {
        Object[] paths;
        String stubPath = StubLoader.getStubLibraryPath();
        Object[] objectArray = paths = new String[]{stubPath, "/" + stubPath};
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = objectArray[n2];
            InputStream is = StubLoader.getResourceAsStream(path);
            if (is == null && StubLoader.getOS() == OS.DARWIN) {
                is = StubLoader.getResourceAsStream(StubLoader.getAlternateLibraryPath(path));
            }
            if (is != null) {
                return is;
            }
            ++n2;
        }
        throw new UnsatisfiedLinkError("could not locate stub library in jar file.  Tried " + Arrays.deepToString(paths));
    }

    private static InputStream getResourceAsStream(String resourceName) {
        ClassLoader[] cls;
        ClassLoader[] classLoaderArray = cls = new ClassLoader[]{ClassLoader.getSystemClassLoader(), StubLoader.class.getClassLoader(), Thread.currentThread().getContextClassLoader()};
        int n = cls.length;
        int n2 = 0;
        while (n2 < n) {
            InputStream is;
            ClassLoader cl = classLoaderArray[n2];
            if (cl != null && (is = cl.getResourceAsStream(resourceName)) != null) {
                return is;
            }
            ++n2;
        }
        return null;
    }

    private static int getVersionField(String name) {
        try {
            Class<?> c = Class.forName(versionClassName);
            return (Integer)c.getField(name).get(c);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static enum CPU {
        I386,
        X86_64,
        PPC,
        PPC64,
        PPC64LE,
        SPARC,
        SPARCV9,
        S390X,
        ARM,
        AARCH64,
        MIPS64EL,
        UNKNOWN;


        public String toString() {
            return this.name().toLowerCase(LOCALE);
        }
    }

    public static enum OS {
        DARWIN,
        FREEBSD,
        NETBSD,
        OPENBSD,
        DRAGONFLY,
        LINUX,
        SOLARIS,
        WINDOWS,
        AIX,
        ZLINUX,
        UNKNOWN;


        public String toString() {
            return this.name().toLowerCase(LOCALE);
        }
    }
}

