/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider.converters;

import jnr.ffi.mapper.ToNativeContext;
import jnr.ffi.mapper.ToNativeConverter;
import jnr.ffi.provider.ParameterFlags;

@ToNativeConverter.NoContext
@ToNativeConverter.Cacheable
public class BoxedBooleanArrayParameterConverter
implements ToNativeConverter<Boolean[], boolean[]> {
    private static final ToNativeConverter<Boolean[], boolean[]> IN = new BoxedBooleanArrayParameterConverter(2);
    private static final ToNativeConverter<Boolean[], boolean[]> OUT = new Out(1);
    private static final ToNativeConverter<Boolean[], boolean[]> INOUT = new Out(3);
    private final int parameterFlags;

    public static ToNativeConverter<Boolean[], boolean[]> getInstance(ToNativeContext toNativeContext) {
        int parameterFlags = ParameterFlags.parse(toNativeContext.getAnnotations());
        return ParameterFlags.isOut(parameterFlags) ? (ParameterFlags.isIn(parameterFlags) ? INOUT : OUT) : IN;
    }

    public BoxedBooleanArrayParameterConverter(int parameterFlags) {
        this.parameterFlags = parameterFlags;
    }

    @Override
    public boolean[] toNative(Boolean[] array, ToNativeContext context) {
        if (array == null) {
            return null;
        }
        boolean[] primitive = new boolean[array.length];
        if (ParameterFlags.isIn(this.parameterFlags)) {
            int i = 0;
            while (i < array.length) {
                primitive[i] = array[i] != null ? array[i] : false;
                ++i;
            }
        }
        return primitive;
    }

    @Override
    public Class<boolean[]> nativeType() {
        return boolean[].class;
    }

    public static final class Out
    extends BoxedBooleanArrayParameterConverter
    implements ToNativeConverter.PostInvocation<Boolean[], boolean[]> {
        Out(int parameterFlags) {
            super(parameterFlags);
        }

        @Override
        public void postInvoke(Boolean[] array, boolean[] primitive, ToNativeContext context) {
            if (array != null && primitive != null) {
                int i = 0;
                while (i < array.length) {
                    array[i] = primitive[i];
                    ++i;
                }
            }
        }
    }
}

