/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider.converters;

import jnr.ffi.mapper.ToNativeContext;
import jnr.ffi.mapper.ToNativeConverter;
import jnr.ffi.provider.ParameterFlags;

@ToNativeConverter.NoContext
@ToNativeConverter.Cacheable
public class BoxedShortArrayParameterConverter
implements ToNativeConverter<Short[], short[]> {
    private static final ToNativeConverter<Short[], short[]> IN = new BoxedShortArrayParameterConverter(2);
    private static final ToNativeConverter<Short[], short[]> OUT = new Out(1);
    private static final ToNativeConverter<Short[], short[]> INOUT = new Out(3);
    private final int parameterFlags;

    public static ToNativeConverter<Short[], short[]> getInstance(ToNativeContext toNativeContext) {
        int parameterFlags = ParameterFlags.parse(toNativeContext.getAnnotations());
        return ParameterFlags.isOut(parameterFlags) ? (ParameterFlags.isIn(parameterFlags) ? INOUT : OUT) : IN;
    }

    public BoxedShortArrayParameterConverter(int parameterFlags) {
        this.parameterFlags = parameterFlags;
    }

    @Override
    public short[] toNative(Short[] array, ToNativeContext context) {
        if (array == null) {
            return null;
        }
        short[] primitive = new short[array.length];
        if (ParameterFlags.isIn(this.parameterFlags)) {
            int i = 0;
            while (i < array.length) {
                primitive[i] = array[i] != null ? array[i] : (short)0;
                ++i;
            }
        }
        return primitive;
    }

    @Override
    public Class<short[]> nativeType() {
        return short[].class;
    }

    public static final class Out
    extends BoxedShortArrayParameterConverter
    implements ToNativeConverter.PostInvocation<Short[], short[]> {
        Out(int parameterFlags) {
            super(parameterFlags);
        }

        @Override
        public void postInvoke(Short[] array, short[] primitive, ToNativeContext context) {
            if (array != null && primitive != null) {
                int i = 0;
                while (i < array.length) {
                    array[i] = primitive[i];
                    ++i;
                }
            }
        }
    }
}

