/*
 * Decompiled with CFR 0.152.
 */
package com.github.s7connector.api.factory;

import com.github.s7connector.api.S7Connector;
import com.github.s7connector.impl.S7TCPConnection;

public class S7ConnectorFactory {
    public static TCPConnectionBuilder buildTCPConnector() {
        return new TCPConnectionBuilder();
    }

    public static class TCPConnectionBuilder {
        private String host;
        private int rack = 0;
        private int slot = 2;
        private int port = 102;

        public S7Connector build() throws Exception {
            return new S7TCPConnection(this.host, this.rack, this.slot, this.port);
        }

        public TCPConnectionBuilder withHost(String host) {
            this.host = host;
            return this;
        }

        public TCPConnectionBuilder withPort(int port) {
            this.port = port;
            return this;
        }

        public TCPConnectionBuilder withRack(int rack) {
            this.rack = rack;
            return this;
        }

        public TCPConnectionBuilder withSlot(int slot) {
            this.slot = slot;
            return this;
        }
    }
}

