/*
 * Decompiled with CFR 0.152.
 */
package com.github.s7connector.impl;

import com.github.s7connector.api.DaveArea;
import com.github.s7connector.api.S7Connector;
import com.github.s7connector.impl.nodave.Nodave;
import com.github.s7connector.impl.nodave.S7Connection;
import java.io.IOException;

public abstract class S7BaseConnection
implements S7Connector {
    public static final String PROPERTY_AREA = "area";
    public static final String PROPERTY_AREANUMBER = "areanumber";
    public static final String PROPERTY_BYTES = "bytes";
    public static final String PROPERTY_OFFSET = "offset";
    private S7Connection dc;

    public static void checkResult(int libnodaveResult) {
        if (libnodaveResult != 0) {
            String msg = Nodave.strerror(libnodaveResult);
            throw new IllegalArgumentException("Result: " + msg);
        }
    }

    protected static void dump(byte[] b) {
        byte[] byArray = b;
        int n = b.length;
        int n2 = 0;
        while (n2 < n) {
            byte element = byArray[n2];
            System.out.print(String.valueOf(Integer.toHexString(element & 0xFF)) + ",");
            ++n2;
        }
    }

    protected void init(S7Connection dc) {
        this.dc = dc;
    }

    @Override
    public synchronized byte[] read(DaveArea area, int areaNumber, int bytes, int offset) throws IOException, InterruptedException {
        int MAX_SIZE = Math.min(102, this.dc.getMaxPDUlength() - 18);
        if (bytes > MAX_SIZE) {
            byte[] ret = new byte[bytes];
            byte[] currentBuffer = this.read(area, areaNumber, MAX_SIZE, offset);
            System.arraycopy(currentBuffer, 0, ret, 0, currentBuffer.length);
            byte[] nextBuffer = this.read(area, areaNumber, bytes - MAX_SIZE, offset + MAX_SIZE);
            System.arraycopy(nextBuffer, 0, ret, currentBuffer.length, nextBuffer.length);
            return ret;
        }
        byte[] buffer = new byte[bytes];
        int ret = this.dc.readBytes(area, areaNumber, offset, bytes, buffer);
        S7BaseConnection.checkResult(ret);
        return buffer;
    }

    @Override
    public byte[] uploadData(DaveArea area, int areaNumber, int bytes, int offset) throws IOException, InterruptedException {
        return this.dc.getProgramBlock(area, areaNumber, offset, bytes);
    }

    @Override
    public synchronized void write(DaveArea area, int areaNumber, int offset, byte[] buffer) throws IOException, InterruptedException {
        int MAX_SIZE = Math.min(102, this.dc.getMaxPDUlength() - 18);
        if (buffer.length > MAX_SIZE) {
            byte[] subBuffer = new byte[MAX_SIZE];
            byte[] nextBuffer = new byte[buffer.length - subBuffer.length];
            System.arraycopy(buffer, 0, subBuffer, 0, subBuffer.length);
            System.arraycopy(buffer, MAX_SIZE, nextBuffer, 0, nextBuffer.length);
            this.write(area, areaNumber, offset, subBuffer);
            this.write(area, areaNumber, offset + subBuffer.length, nextBuffer);
        } else {
            int ret = this.dc.writeBytes(area, areaNumber, offset, buffer.length, buffer);
            S7BaseConnection.checkResult(ret);
        }
    }
}

