/*
 * Decompiled with CFR 0.152.
 */
package com.github.s7connector.impl;

import com.github.s7connector.api.DaveArea;
import com.github.s7connector.impl.S7BaseConnection;
import com.github.s7connector.impl.nodave.PLCinterface;
import com.github.s7connector.impl.nodave.TCPConnection;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;

public final class S7TCPConnection
extends S7BaseConnection {
    private TCPConnection dc;
    private PLCinterface di;
    private final String host;
    private final int port;
    private final int rack;
    private final int slot;
    private Socket socket;

    public S7TCPConnection(String host, int rack, int slot, int port) throws Exception {
        this.host = host;
        this.rack = rack;
        this.slot = slot;
        this.port = port;
        this.setupSocket();
    }

    @Override
    public void close() throws IOException {
        this.socket.close();
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    private void setupSocket() throws Exception {
        this.socket = new Socket();
        this.socket.setSoTimeout(2000);
        this.socket.connect(new InetSocketAddress(this.host, this.port));
        this.di = new PLCinterface(this.socket.getOutputStream(), this.socket.getInputStream(), "IF1", DaveArea.LOCAL.getCode(), 4);
        this.dc = new TCPConnection(this.di, this.rack, this.slot);
        int res = this.dc.connectPLC();
        S7TCPConnection.checkResult(res);
        super.init(this.dc);
    }
}

