/*
 * Decompiled with CFR 0.152.
 */
package com.github.s7connector.impl.nodave;

public final class Nodave {
    public static final int MAX_RAW_LEN = 2048;
    public static final int MPIReachable = 48;
    public static final int MPIunused = 16;
    public static final int OrderCodeSize = 21;
    public static final int PartnerListSize = 126;
    public static final int PROTOCOL_ISOTCP = 4;
    public static final int PROTOCOL_ISOTCP243 = 5;
    public static final int PROTOCOL_MPI_IBH = 223;
    public static final int PROTOCOL_MPI_NLPRO = 230;
    public static final int PROTOCOL_NLPRO = 230;
    public static final int PROTOCOL_PPI_IBH = 224;
    public static final int RESULT_ADDRESS_OUT_OF_RANGE = 5;
    public static final int RESULT_CANNOT_EVALUATE_PDU = -123;
    public static final int RESULT_CPU_RETURNED_NO_DATA = -124;
    public static final int RESULT_EMPTY_RESULT_ERROR = -126;
    public static final int RESULT_EMPTY_RESULT_SET_ERROR = -127;
    public static final int RESULT_ITEM_NOT_AVAILABLE = 10;
    public static final int RESULT_ITEM_NOT_AVAILABLE200 = 3;
    public static final int RESULT_MULTIPLE_BITS_NOT_SUPPORTED = 6;
    public static final int RESULT_NO_PERIPHERAL_AT_ADDRESS = 1;
    public static final int RESULT_OK = 0;
    public static final int RESULT_SHORT_PACKET = -1024;
    public static final int RESULT_TIMEOUT = -1025;
    public static final int RESULT_UNEXPECTED_FUNC = -128;
    public static final int RESULT_UNKNOWN_DATA_UNIT_SIZE = -129;
    public static final int RESULT_UNKNOWN_ERROR = -125;
    public static final int RESULT_WRITE_DATA_SIZE_MISMATCH = 7;

    public static float BEFloat(byte[] b, int pos) {
        int i = 0;
        i |= Nodave.USByte(b, pos);
        i <<= 8;
        i |= Nodave.USByte(b, pos + 1);
        i <<= 8;
        i |= Nodave.USByte(b, pos + 2);
        i <<= 8;
        float f = Float.intBitsToFloat(i |= Nodave.USByte(b, pos + 3));
        return f;
    }

    public static byte[] bswap_16(int a) {
        byte[] b = new byte[2];
        b[1] = (byte)(a & 0xFF);
        b[0] = (byte)((a >>= 8) & 0xFF);
        return b;
    }

    public static byte[] bswap_32(int a) {
        byte[] b = new byte[4];
        b[3] = (byte)(a & 0xFF);
        b[2] = (byte)((a >>= 8) & 0xFF);
        b[1] = (byte)((a >>= 8) & 0xFF);
        b[0] = (byte)((a >>= 8) & 0xFF);
        return b;
    }

    public static byte[] bswap_32(long a) {
        byte[] b = new byte[4];
        b[3] = (byte)(a & 0xFFL);
        b[2] = (byte)((a >>= 8) & 0xFFL);
        b[1] = (byte)((a >>= 8) & 0xFFL);
        b[0] = (byte)((a >>= 8) & 0xFFL);
        return b;
    }

    public static byte[] bswap_8(int a) {
        byte[] b = new byte[]{(byte)(a & 0xFF)};
        return b;
    }

    public static void dump(String text, byte[] mem, int start, int len) {
        System.out.print(String.valueOf(text) + " ");
        int i = start;
        while (i < start + len) {
            String s;
            int j = mem[i];
            if (j < 0) {
                j += 256;
            }
            if ((s = Integer.toHexString(j)).length() < 2) {
                s = "0" + s;
            }
            System.out.print(String.valueOf(s) + ",");
            ++i;
        }
        System.out.println(" ");
    }

    public static long SBELong(byte[] b, int pos) {
        byte i = b[pos];
        int j = b[pos + 1];
        int k = b[pos + 2];
        int l = b[pos + 3];
        if (j < 0) {
            j += 256;
        }
        if (k < 0) {
            k += 256;
        }
        if (l < 0) {
            l += 256;
        }
        return (long)(256 * k + l) + 65536L * (long)(256 * i + j);
    }

    public static int SBEWord(byte[] b, int pos) {
        byte i = b[pos];
        int k = b[pos + 1];
        if (k < 0) {
            k += 256;
        }
        return 256 * i + k;
    }

    public static int SByte(byte[] b, int pos) {
        byte i = b[pos];
        return i;
    }

    public static void setBEFloat(byte[] b, int pos, float f) {
        int a = Float.floatToIntBits(f);
        b[pos + 3] = (byte)(a & 0xFF);
        b[pos + 2] = (byte)((a >>= 8) & 0xFF);
        b[pos + 1] = (byte)((a >>= 8) & 0xFF);
        b[pos] = (byte)((a >>= 8) & 0xFF);
    }

    public static void setUSBELong(byte[] b, int pos, long val) {
        b[pos + 3] = (byte)(val & 0xFFL);
        b[pos + 2] = (byte)((val >>= 8) & 0xFFL);
        b[pos + 1] = (byte)((val >>= 8) & 0xFFL);
        b[pos] = (byte)((val >>= 8) & 0xFFL);
    }

    public static void setUSBEWord(byte[] b, int pos, int val) {
        b[pos + 1] = (byte)(val & 0xFF);
        b[pos] = (byte)((val >>= 8) & 0xFF);
    }

    public static void setUSByte(byte[] b, int pos, int val) {
        b[pos] = (byte)(val & 0xFF);
    }

    public static String strerror(int code) {
        switch (code) {
            case 0: {
                return "ok";
            }
            case 6: {
                return "the CPU does not support reading a bit block of length<>1";
            }
            case 10: {
                return "the desired item is not available in the PLC";
            }
            case 3: {
                return "the desired item is not available in the PLC (200 family)";
            }
            case 5: {
                return "the desired address is beyond limit for this PLC";
            }
            case -124: {
                return "the PLC returned a packet with no result data";
            }
            case -125: {
                return "the PLC returned an error code not understood by this library";
            }
            case -126: {
                return "this result contains no data";
            }
            case -127: {
                return "cannot work with an undefined result set";
            }
            case -123: {
                return "cannot evaluate the received PDU";
            }
            case 7: {
                return "Write data size error";
            }
            case 1: {
                return "No data from I/O module";
            }
            case -128: {
                return "Unexpected function code in answer";
            }
            case -129: {
                return "PLC responds wit an unknown data type";
            }
            case -1024: {
                return "Short packet from PLC";
            }
            case -1025: {
                return "Timeout when waiting for PLC response";
            }
            case 32768: {
                return "function already occupied.";
            }
            case 32769: {
                return "not allowed in current operating status.";
            }
            case 33025: {
                return "hardware fault.";
            }
            case 33027: {
                return "object access not allowed.";
            }
            case 33028: {
                return "context is not supported.";
            }
            case 33029: {
                return "invalid address.";
            }
            case 33030: {
                return "data type not supported.";
            }
            case 33031: {
                return "data type not consistent.";
            }
            case 33034: {
                return "object does not exist.";
            }
            case 34048: {
                return "incorrect PDU size.";
            }
            case 34562: {
                return "address invalid.";
            }
            case 53761: {
                return "block name syntax error.";
            }
            case 53762: {
                return "syntax error function parameter.";
            }
            case 53763: {
                return "syntax error block type.";
            }
            case 53764: {
                return "no linked block in storage medium.";
            }
            case 53765: {
                return "object already exists.";
            }
            case 53766: {
                return "object already exists.";
            }
            case 53767: {
                return "block exists in EPROM.";
            }
            case 53769: {
                return "block does not exist.";
            }
            case 53774: {
                return "no block does not exist.";
            }
            case 53776: {
                return "block number too big.";
            }
            case 53824: {
                return "unfinished block transfer in progress?";
            }
            case 53825: {
                return "protected by password.";
            }
        }
        return "no message defined for code: " + code + "!";
    }

    public static byte[] toPLCfloat(double d) {
        float f = (float)d;
        return Nodave.toPLCfloat(f);
    }

    public static byte[] toPLCfloat(float f) {
        int i = Float.floatToIntBits(f);
        return Nodave.bswap_32(i);
    }

    public static long USBELong(byte[] b, int pos) {
        int i = b[pos];
        int j = b[pos + 1];
        int k = b[pos + 2];
        int l = b[pos + 3];
        if (i < 0) {
            i += 256;
        }
        if (j < 0) {
            j += 256;
        }
        if (k < 0) {
            k += 256;
        }
        if (l < 0) {
            l += 256;
        }
        return (long)(256 * k + l) + 65536L * (long)(256 * i + j);
    }

    public static int USBEWord(byte[] b, int pos) {
        int i = b[pos];
        int k = b[pos + 1];
        if (i < 0) {
            i += 256;
        }
        if (k < 0) {
            k += 256;
        }
        return 256 * i + k;
    }

    public static int USByte(byte[] b, int pos) {
        int i = b[pos];
        if (i < 0) {
            i += 256;
        }
        return i;
    }

    private Nodave() {
    }
}

