/*
 * Decompiled with CFR 0.152.
 */
package com.github.s7connector.impl.nodave;

import com.github.s7connector.api.DaveArea;
import com.github.s7connector.impl.nodave.Nodave;

public final class PDU {
    public static final byte FUNC_READ = 4;
    public static final byte FUNC_WRITE = 5;
    public static final byte FUNC_START_UPLOAD = 29;
    public static final byte FUNC_DO_UPLOAD = 30;
    public static final byte FUNC_END_UPLOAD = 31;
    public int data;
    int dlen;
    int error;
    int header;
    int hlen;
    byte[] mem;
    public int param;
    public int plen;
    public int udata;
    public int udlen;

    public PDU(byte[] mem, int pos) {
        this.mem = mem;
        this.header = pos;
    }

    public int addBitVarToReadRequest(int area, int DBnum, int start, int len) {
        byte[] byArray = new byte[12];
        byArray[0] = 18;
        byArray[1] = 10;
        byArray[2] = 16;
        byArray[3] = 1;
        byArray[5] = 26;
        byArray[7] = 11;
        byArray[8] = -124;
        byArray[11] = -64;
        byte[] pa = byArray;
        Nodave.setUSBEWord(pa, 4, len);
        Nodave.setUSBEWord(pa, 6, DBnum);
        Nodave.setUSBELong(pa, 8, start);
        Nodave.setUSByte(pa, 8, area);
        int n = this.param + 1;
        this.mem[n] = (byte)(this.mem[n] + 1);
        System.arraycopy(pa, 0, this.mem, this.param + this.plen, pa.length);
        this.plen += pa.length;
        Nodave.setUSBEWord(this.mem, this.header + 6, this.plen);
        return 0;
    }

    public void addBitVarToWriteRequest(DaveArea area, int DBnum, int start, int byteCount, byte[] buffer) {
        byte[] byArray = new byte[4];
        byArray[1] = 3;
        byte[] da = byArray;
        byte[] byArray2 = new byte[12];
        byArray2[0] = 18;
        byArray2[1] = 10;
        byArray2[2] = 16;
        byArray2[3] = 1;
        byte[] pa = byArray2;
        if (area == DaveArea.TIMER || area == DaveArea.COUNTER || area == DaveArea.TIMER200 || area == DaveArea.COUNTER200) {
            pa[3] = (byte)area.getCode();
            pa[4] = (byte)((byteCount + 1) / 2 / 256);
            pa[5] = (byte)((byteCount + 1) / 2 & 0xFF);
        } else if (area == DaveArea.ANALOGINPUTS200 || area == DaveArea.ANALOGOUTPUTS200) {
            pa[3] = 4;
            pa[4] = (byte)((byteCount + 1) / 2 / 256);
            pa[5] = (byte)((byteCount + 1) / 2 & 0xFF);
        } else {
            pa[4] = (byte)(byteCount / 256);
            pa[5] = (byte)(byteCount & 0xFF);
        }
        pa[6] = (byte)(DBnum / 256);
        pa[7] = (byte)(DBnum & 0xFF);
        pa[8] = (byte)area.getCode();
        pa[11] = (byte)(start & 0xFF);
        pa[10] = (byte)(start / 256 & 0xFF);
        pa[9] = (byte)(start / 65536);
        if (this.dlen % 2 != 0) {
            this.addData(da, 1);
        }
        int n = this.param + 1;
        this.mem[n] = (byte)(this.mem[n] + 1);
        if (this.dlen > 0) {
            byte[] saveData = new byte[this.dlen];
            System.arraycopy(this.mem, this.data, saveData, 0, this.dlen);
            System.arraycopy(saveData, 0, this.mem, this.data + pa.length, this.dlen);
        }
        System.arraycopy(pa, 0, this.mem, this.param + this.plen, pa.length);
        this.plen += pa.length;
        Nodave.setUSBEWord(this.mem, this.header + 6, this.plen);
        this.data = this.param + this.plen;
        this.addData(da);
        this.addValue(buffer);
    }

    void addData(byte[] newData) {
        int appPos = this.data + this.dlen;
        this.dlen += newData.length;
        System.arraycopy(newData, 0, this.mem, appPos, newData.length);
        Nodave.setUSBEWord(this.mem, this.header + 8, this.dlen);
    }

    public void addData(byte[] newData, int len) {
        int appPos = this.data + this.dlen;
        this.dlen += len;
        System.arraycopy(newData, 0, this.mem, appPos, len);
        Nodave.setUSBEWord(this.mem, this.header + 8, this.dlen);
    }

    public void addParam(byte[] pa) {
        this.plen = pa.length;
        System.arraycopy(pa, 0, this.mem, this.param, this.plen);
        Nodave.setUSBEWord(this.mem, this.header + 6, this.plen);
        this.data = this.param + this.plen;
        this.dlen = 0;
    }

    public void addUserData(byte[] da) {
        byte[] byArray = new byte[4];
        byArray[0] = -1;
        byArray[1] = 9;
        byte[] udh = byArray;
        if (this.dlen == 0) {
            this.addData(udh);
        }
        this.addValue(da);
    }

    void addValue(byte[] values) {
        int valCount = 256 * this.mem[this.data + 2] + this.mem[this.data + 3];
        if (this.mem[this.data + 1] == 4) {
            valCount += 8 * values.length;
        } else if (this.mem[this.data + 1] == 9) {
            valCount += values.length;
        }
        if (this.udata == 0) {
            this.udata = this.data + 4;
        }
        this.udlen += values.length;
        Nodave.setUSBEWord(this.mem, this.data + 2, valCount);
        this.addData(values);
    }

    public int addVarToReadRequest(DaveArea area, int DBnum, int start, int len) {
        byte[] byArray = new byte[12];
        byArray[0] = 18;
        byArray[1] = 10;
        byArray[2] = 16;
        byArray[3] = 2;
        byArray[5] = 26;
        byArray[7] = 11;
        byArray[8] = -124;
        byArray[11] = -64;
        byte[] pa = byArray;
        if (area == DaveArea.ANALOGINPUTS200 || area == DaveArea.ANALOGOUTPUTS200) {
            pa[3] = 4;
            start *= 8;
        } else if (area == DaveArea.TIMER || area == DaveArea.COUNTER || area == DaveArea.TIMER200 || area == DaveArea.COUNTER200) {
            pa[3] = (byte)area.getCode();
        } else {
            start *= 8;
        }
        Nodave.setUSBEWord(pa, 4, len);
        Nodave.setUSBEWord(pa, 6, DBnum);
        Nodave.setUSBELong(pa, 8, start);
        Nodave.setUSByte(pa, 8, area.getCode());
        int n = this.param + 1;
        this.mem[n] = (byte)(this.mem[n] + 1);
        System.arraycopy(pa, 0, this.mem, this.param + this.plen, pa.length);
        this.plen += pa.length;
        Nodave.setUSBEWord(this.mem, this.header + 6, this.plen);
        return 0;
    }

    public void addVarToWriteRequest(DaveArea area, int DBnum, int start, int byteCount, byte[] buffer) {
        byte[] byArray = new byte[4];
        byArray[1] = 4;
        byte[] da = byArray;
        byte[] byArray2 = new byte[12];
        byArray2[0] = 18;
        byArray2[1] = 10;
        byArray2[2] = 16;
        byArray2[3] = 2;
        byte[] pa = byArray2;
        if (area == DaveArea.TIMER || area == DaveArea.COUNTER || area == DaveArea.TIMER200 || area == DaveArea.COUNTER200) {
            pa[3] = (byte)area.getCode();
            pa[4] = (byte)((byteCount + 1) / 2 / 256);
            pa[5] = (byte)((byteCount + 1) / 2 & 0xFF);
        } else if (area == DaveArea.ANALOGINPUTS200 || area == DaveArea.ANALOGOUTPUTS200) {
            pa[3] = 4;
            pa[4] = (byte)((byteCount + 1) / 2 / 256);
            pa[5] = (byte)((byteCount + 1) / 2 & 0xFF);
        } else {
            pa[4] = (byte)(byteCount / 256);
            pa[5] = (byte)(byteCount & 0xFF);
        }
        pa[6] = (byte)(DBnum / 256);
        pa[7] = (byte)(DBnum & 0xFF);
        pa[8] = (byte)area.getCode();
        pa[11] = (byte)((start *= 8) & 0xFF);
        pa[10] = (byte)(start / 256 & 0xFF);
        pa[9] = (byte)(start / 65536);
        if (this.dlen % 2 != 0) {
            this.addData(da, 1);
        }
        int n = this.param + 1;
        this.mem[n] = (byte)(this.mem[n] + 1);
        if (this.dlen > 0) {
            byte[] saveData = new byte[this.dlen];
            System.arraycopy(this.mem, this.data, saveData, 0, this.dlen);
            System.arraycopy(saveData, 0, this.mem, this.data + pa.length, this.dlen);
        }
        System.arraycopy(pa, 0, this.mem, this.param + this.plen, pa.length);
        this.plen += pa.length;
        Nodave.setUSBEWord(this.mem, this.header + 6, this.plen);
        this.data = this.param + this.plen;
        this.addData(da);
        this.addValue(buffer);
    }

    public void dump() {
        Nodave.dump("PDU header ", this.mem, this.header, this.hlen);
        System.out.println("plen: " + this.plen + " dlen: " + this.dlen);
        Nodave.dump("Parameter", this.mem, this.param, this.plen);
        if (this.dlen > 0) {
            Nodave.dump("Data     ", this.mem, this.data, this.dlen);
        }
        if (this.udlen > 0) {
            Nodave.dump("result Data ", this.mem, this.udata, this.udlen);
        }
    }

    public int getError() {
        return this.error;
    }

    public int getFunc() {
        return Nodave.USByte(this.mem, this.param + 0);
    }

    public int getNumber() {
        return Nodave.USBEWord(this.mem, this.header + 4);
    }

    public void initHeader(int type) {
        this.hlen = type == 2 || type == 3 ? 12 : 10;
        int i = 0;
        while (i < this.hlen) {
            this.mem[this.header + i] = 0;
            ++i;
        }
        this.param = this.header + this.hlen;
        this.mem[this.header] = 50;
        this.mem[this.header + 1] = (byte)type;
        this.dlen = 0;
        this.plen = 0;
        this.udlen = 0;
        this.data = 0;
        this.udata = 0;
    }

    public void initReadRequest() {
        byte[] pa = new byte[]{4, 0};
        this.initHeader(1);
        this.addParam(pa);
    }

    public void prepareReadRequest() {
        byte[] pa = new byte[]{4, 0};
        this.initHeader(1);
        this.addParam(pa);
    }

    public void prepareWriteRequest() {
        byte[] pa = new byte[]{5, 0};
        this.initHeader(1);
        this.addParam(pa);
    }

    public void setNumber(int n) {
        Nodave.setUSBEWord(this.mem, this.header + 4, n);
    }

    public int setupReceivedPDU() {
        int res = -123;
        if (this.mem[this.header + 1] == 2 || this.mem[this.header + 1] == 3) {
            this.hlen = 12;
            res = Nodave.USBEWord(this.mem, this.header + 10);
        } else {
            this.error = 0;
            this.hlen = 10;
            res = 0;
        }
        this.param = this.header + this.hlen;
        this.plen = Nodave.USBEWord(this.mem, this.header + 6);
        this.data = this.param + this.plen;
        this.dlen = Nodave.USBEWord(this.mem, this.header + 8);
        this.udlen = 0;
        this.udata = 0;
        return res;
    }

    public int testPGReadResult() {
        if (this.mem[this.param] != 0) {
            return -128;
        }
        return this.testResultData();
    }

    int testReadResult() {
        if (this.mem[this.param] != 4) {
            return -128;
        }
        return this.testResultData();
    }

    int testStartUploadResult() {
        if (this.mem[this.param] != 29) {
            return -128;
        }
        return this.testResultData();
    }

    int testDoUploadResult() {
        if (this.mem[this.param] != 30) {
            return -128;
        }
        return this.testResultData();
    }

    int testEndUploadResult() {
        if (this.mem[this.param] != 31) {
            return -128;
        }
        return this.testResultData();
    }

    int testResultData() {
        int res = -123;
        if (this.mem[this.data] == -1 && this.dlen > 4) {
            res = 0;
            this.udata = this.data + 4;
            this.udlen = Nodave.USBEWord(this.mem, this.data + 2);
            if (this.mem[this.data + 1] == 4) {
                this.udlen >>= 3;
            } else if (this.mem[this.data + 1] != 9 && this.mem[this.data + 1] != 3) {
                res = -129;
            }
        } else {
            res = this.mem[this.data];
        }
        return res;
    }

    int testWriteResult() {
        int res = -123;
        if (this.mem[this.param] != 5) {
            return -128;
        }
        res = this.mem[this.data] == 255 ? 0 : this.mem[this.data];
        return res;
    }

    public void constructBlockInfoRequest(DaveArea area, int dbNum) {
        byte[] byArray = new byte[8];
        byArray[1] = 1;
        byArray[2] = 18;
        byArray[3] = 4;
        byArray[4] = 17;
        byArray[5] = 67;
        byArray[6] = 3;
        byte[] pa = byArray;
        byte[] byArray2 = new byte[8];
        byArray2[0] = 48;
        byArray2[2] = 48;
        byArray2[3] = 48;
        byArray2[4] = 48;
        byArray2[5] = 48;
        byArray2[6] = 49;
        byArray2[7] = 65;
        byte[] da = byArray2;
        Nodave.setUSByte(da, 1, area.getBlockType());
        char[] code = Integer.toString(dbNum).toCharArray();
        int i = 0;
        while (i < code.length) {
            Nodave.setUSByte(da, 7 - code.length + i, code[i]);
            ++i;
        }
        this.initHeader(7);
        this.addParam(pa);
        this.addUserData(da);
    }

    public void constructUpload(DaveArea area, int dbNum) {
        byte[] byArray = new byte[18];
        byArray[0] = 29;
        byArray[8] = 9;
        byArray[9] = 95;
        byArray[10] = 48;
        byArray[11] = 65;
        byArray[12] = 48;
        byArray[13] = 48;
        byArray[14] = 48;
        byArray[15] = 48;
        byArray[16] = 49;
        byArray[17] = 65;
        byte[] pa = byArray;
        Nodave.setUSByte(pa, 11, area.getBlockType());
        char[] code = Integer.toString(dbNum).toCharArray();
        int i = 0;
        while (i < code.length) {
            Nodave.setUSByte(pa, 17 - code.length + i, code[i]);
            ++i;
        }
        pa[17] = 65;
        this.initHeader(1);
        this.addParam(pa);
    }

    public void constructDoUpload(int uploadID) {
        byte[] byArray = new byte[8];
        byArray[0] = 30;
        byArray[7] = 1;
        byte[] pa = byArray;
        Nodave.setUSByte(pa, 7, uploadID);
        this.initHeader(1);
        this.addParam(pa);
    }

    public void constructEndUpload(int uploadID) {
        byte[] byArray = new byte[8];
        byArray[0] = 31;
        byArray[7] = 1;
        byte[] pa = byArray;
        Nodave.setUSByte(pa, 7, uploadID);
        this.initHeader(1);
        this.addParam(pa);
    }
}

