/*
 * Decompiled with CFR 0.152.
 */
package com.github.s7connector.impl.nodave;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class PLCinterface {
    InputStream in;
    int localMPI;
    String name;
    OutputStream out;
    int protocol;
    int wp;
    int rp;

    public PLCinterface(OutputStream out, InputStream in, String name, int localMPI, int protocol) {
        this.init(out, in, name, localMPI, protocol);
    }

    public void init(OutputStream oStream, InputStream iStream, String name, int localMPI, int protocol) {
        this.out = oStream;
        this.in = iStream;
        this.name = name;
        this.localMPI = localMPI;
        this.protocol = protocol;
    }

    public int read(byte[] b, int start, int len) throws IOException, InterruptedException {
        int retry = 0;
        while (this.in.available() <= 0) {
            if (retry > 0) {
                Thread.sleep(1L);
            }
            if (++retry < 500) continue;
            throw new IOException("Timeout reasched");
        }
        int res = 0;
        while (this.in.available() > 0 && len > 0) {
            res = this.in.read(b, start, len);
            start += res;
            len -= res;
        }
        return res;
    }

    public void write(byte[] b, int start, int len) throws IOException {
        this.out.write(b, start, len);
    }
}

