/*
 * Decompiled with CFR 0.152.
 */
package com.github.s7connector.impl.nodave;

import com.github.s7connector.api.DaveArea;
import com.github.s7connector.impl.S7BaseConnection;
import com.github.s7connector.impl.nodave.BlockInfo;
import com.github.s7connector.impl.nodave.Nodave;
import com.github.s7connector.impl.nodave.PDU;
import com.github.s7connector.impl.nodave.PLCinterface;
import com.github.s7connector.impl.nodave.Result;
import com.github.s7connector.impl.nodave.ResultSet;
import com.github.s7connector.impl.nodave.UploadResult;
import java.io.IOException;
import java.util.concurrent.Semaphore;

public abstract class S7Connection {
    static int tmo_normal = 150;
    int answLen;
    int dataPointer;
    PLCinterface iface;
    public int maxPDUlength;
    public byte messageNumber = 0;
    public byte[] msgIn;
    public byte[] msgOut;
    public int packetNumber = 0;
    public int PDUstartIn;
    public int PDUstartOut;
    PDU rcvdPDU;
    public Semaphore semaphore;
    int udata;

    public S7Connection(PLCinterface ifa) {
        this.iface = ifa;
        this.msgIn = new byte[2048];
        this.msgOut = new byte[2048];
        this.PDUstartIn = 0;
        this.PDUstartOut = 0;
        this.semaphore = new Semaphore(1);
    }

    public abstract int exchange(PDU var1) throws IOException, InterruptedException;

    public ResultSet execReadRequest(PDU p) throws IOException, InterruptedException {
        int errorState = this.exchange(p);
        PDU p2 = new PDU(this.msgIn, this.PDUstartIn);
        p2.setupReceivedPDU();
        ResultSet rs = new ResultSet();
        if (p2.mem[p2.param + 0] == 4) {
            int numResults = p2.mem[p2.param + 1];
            rs.results = new Result[numResults];
            int pos = p2.data;
            int i = 0;
            while (i < numResults) {
                Result r = new Result();
                r.error = Nodave.USByte(p2.mem, pos);
                if (r.error == 255) {
                    int type = Nodave.USByte(p2.mem, pos + 1);
                    int len = Nodave.USBEWord(p2.mem, pos + 2);
                    r.error = 0;
                    if (type == 4) {
                        len /= 8;
                    } else if (type == 3) {
                        // empty if block
                    }
                    r.bufferStart = pos + 4;
                    pos += len;
                    if (len % 2 == 1) {
                        ++pos;
                    }
                } else {
                    System.out.println("Error " + r.error);
                }
                pos += 4;
                rs.results[i] = r;
                ++i;
            }
            numResults = p2.mem[p2.param + 1];
            rs.setNumResults(numResults);
            this.dataPointer = p2.udata;
            this.answLen = p2.udlen;
        } else {
            errorState |= 0x800;
        }
        this.semaphore.release();
        rs.setErrorState(errorState);
        return rs;
    }

    public int getBYTE() {
        ++this.dataPointer;
        return Nodave.SByte(this.msgIn, this.dataPointer - 1);
    }

    public int getBYTE(int pos) {
        return Nodave.SByte(this.msgIn, this.udata + pos);
    }

    public int getCHAR() {
        ++this.dataPointer;
        return Nodave.SByte(this.msgIn, this.dataPointer - 1);
    }

    public int getCHAR(int pos) {
        return Nodave.SByte(this.msgIn, this.udata + pos);
    }

    public long getDINT() {
        this.dataPointer += 4;
        return Nodave.SBELong(this.msgIn, this.dataPointer - 4);
    }

    public long getDINT(int pos) {
        return Nodave.SBELong(this.msgIn, this.udata + pos);
    }

    public long getDWORD(int pos) {
        return Nodave.USBELong(this.msgIn, this.udata + pos);
    }

    public float getFloat() {
        this.dataPointer += 4;
        return Nodave.BEFloat(this.msgIn, this.dataPointer - 4);
    }

    public float getFloat(int pos) {
        return Nodave.BEFloat(this.msgIn, this.udata + pos);
    }

    public int getINT() {
        this.dataPointer += 2;
        return Nodave.SBEWord(this.msgIn, this.dataPointer - 2);
    }

    public int getINT(int pos) {
        return Nodave.SBEWord(this.msgIn, this.udata + pos);
    }

    public int getPPIresponse() {
        return 0;
    }

    public int getResponse() {
        return 0;
    }

    public int getS16(int pos) {
        return Nodave.SBEWord(this.msgIn, this.udata + pos);
    }

    public long getS32(int pos) {
        return Nodave.SBELong(this.msgIn, this.udata + pos);
    }

    public int getS8(int pos) {
        return Nodave.SByte(this.msgIn, this.udata + pos);
    }

    public long getU32() {
        this.dataPointer += 4;
        return Nodave.USBELong(this.msgIn, this.dataPointer - 4);
    }

    public int getUS16(int pos) {
        return Nodave.USBEWord(this.msgIn, this.udata + pos);
    }

    public long getUS32(int pos) {
        return Nodave.USBELong(this.msgIn, this.udata + pos);
    }

    public int getUS8(int pos) {
        return Nodave.USByte(this.msgIn, this.udata + pos);
    }

    public int getWORD() {
        this.dataPointer += 2;
        return Nodave.USBEWord(this.msgIn, this.dataPointer - 2);
    }

    public int getWORD(int pos) {
        return Nodave.USBEWord(this.msgIn, this.udata + pos);
    }

    public int getMaxPDUlength() {
        return this.maxPDUlength;
    }

    public int negPDUlengthRequest() throws IOException, InterruptedException {
        PDU p = new PDU(this.msgOut, this.PDUstartOut);
        byte[] byArray = new byte[8];
        byArray[0] = -16;
        byArray[3] = 1;
        byArray[5] = 1;
        byArray[6] = 3;
        byArray[7] = -64;
        byte[] pa = byArray;
        p.initHeader(1);
        p.addParam(pa);
        int res = this.exchange(p);
        if (res != 0) {
            return res;
        }
        PDU p2 = new PDU(this.msgIn, this.PDUstartIn);
        res = p2.setupReceivedPDU();
        if (res != 0) {
            return res;
        }
        this.maxPDUlength = Nodave.USBEWord(this.msgIn, p2.param + 6);
        return res;
    }

    public int readBytes(DaveArea area, int DBnum, int start, int len, byte[] buffer) throws IOException, InterruptedException {
        int res = 0;
        try {
            this.semaphore.acquire();
            PDU p1 = new PDU(this.msgOut, this.PDUstartOut);
            p1.initReadRequest();
            p1.addVarToReadRequest(area, DBnum, start, len);
            res = this.exchange(p1);
            if (res != 0) {
                int n = res;
                return n;
            }
            PDU p2 = new PDU(this.msgIn, this.PDUstartIn);
            res = p2.setupReceivedPDU();
            if (res != 0) {
                int n = res;
                return n;
            }
            res = p2.testReadResult();
            if (res != 0) {
                int n = res;
                return n;
            }
            if (p2.udlen == 0) {
                return -124;
            }
            if (buffer != null) {
                System.arraycopy(p2.mem, p2.udata, buffer, 0, p2.udlen);
            }
            this.dataPointer = p2.udata;
            this.udata = p2.udata;
            this.answLen = p2.udlen;
            int n = res;
            return n;
        }
        finally {
            this.semaphore.release();
        }
    }

    public int sendMsg(PDU p) {
        return 0;
    }

    public void sendRequestData(int alt) {
    }

    public int useResult(ResultSet rs, int number) {
        System.out.println("rs.getNumResults: " + rs.getNumResults() + " number: " + number);
        if (rs.getNumResults() > number) {
            this.dataPointer = rs.results[number].bufferStart;
            return 0;
        }
        return -33;
    }

    public int writeBytes(DaveArea area, int DBnum, int start, int len, byte[] buffer) throws IOException, InterruptedException {
        int errorState = 0;
        try {
            this.semaphore.release();
            PDU p1 = new PDU(this.msgOut, this.PDUstartOut);
            p1.prepareWriteRequest();
            p1.addVarToWriteRequest(area, DBnum, start, len, buffer);
            errorState = this.exchange(p1);
            if (errorState == 0) {
                PDU p2 = new PDU(this.msgIn, this.PDUstartIn);
                p2.setupReceivedPDU();
                if (p2.mem[p2.param + 0] == 5) {
                    if (p2.mem[p2.data + 0] == -1) {
                        this.semaphore.release();
                        return 0;
                    }
                } else {
                    errorState |= 0x1000;
                }
            }
            int n = errorState;
            return n;
        }
        finally {
            this.semaphore.release();
        }
    }

    public int getBlockInfo(DaveArea area, int dbNum, BlockInfo blockInfo) throws IOException, InterruptedException {
        PDU p1 = new PDU(this.msgOut, this.PDUstartOut);
        p1.constructBlockInfoRequest(area, dbNum);
        int res = this.exchange(p1);
        S7BaseConnection.checkResult(res);
        PDU p2 = new PDU(this.msgIn, this.PDUstartIn);
        res = p2.setupReceivedPDU();
        S7BaseConnection.checkResult(res);
        res = p2.testResultData();
        S7BaseConnection.checkResult(res);
        if (blockInfo != null && p2.udlen == BlockInfo.SIZE) {
            int udata = p2.udata;
            blockInfo.blockType = Nodave.USBEWord(p2.mem, udata);
            blockInfo.legthInfo = Nodave.USBEWord(p2.mem, udata + 2);
            System.arraycopy(p2.mem, udata + 4, blockInfo.w1, 0, 2);
            System.arraycopy(p2.mem, udata + 6, blockInfo.pp, 0, 2);
            blockInfo.unknownByteBlockinfo = p2.mem[udata + 8];
            blockInfo.blockFlags = p2.mem[udata + 9];
            blockInfo.blockLanguage = p2.mem[udata + 10];
            blockInfo.subblkType = p2.mem[udata + 11];
            blockInfo.blockNumber = Nodave.USBEWord(p2.mem, udata + 12);
            blockInfo.lengthLoadMemory = Nodave.USBELong(p2.mem, udata + 14);
            blockInfo.blockSecurity = Nodave.USBELong(p2.mem, udata + 18);
            System.arraycopy(p2.mem, udata + 22, blockInfo.codeTimestamp, 0, 6);
            System.arraycopy(p2.mem, udata + 28, blockInfo.interfaceTimestamp, 0, 6);
            blockInfo.ssbLength = Nodave.USBEWord(p2.mem, udata + 34);
            blockInfo.addLength = Nodave.USBEWord(p2.mem, udata + 36);
            blockInfo.localDataLength = Nodave.USBEWord(p2.mem, udata + 38);
            blockInfo.mc7CodeLength = Nodave.USBEWord(p2.mem, udata + 40);
        }
        return res;
    }

    public int initUpload(DaveArea area, int DBnum) throws IOException, InterruptedException {
        PDU p1 = new PDU(this.msgOut, this.PDUstartOut);
        p1.constructUpload(area, DBnum);
        int res = this.exchange(p1);
        S7BaseConnection.checkResult(res);
        PDU p2 = new PDU(this.msgIn, this.PDUstartIn);
        res = p2.setupReceivedPDU();
        S7BaseConnection.checkResult(res);
        res = p2.testStartUploadResult();
        S7BaseConnection.checkResult(res);
        return Nodave.USByte(p2.mem, p2.param + 7);
    }

    public void doUpload(int uploadID, byte[] buffer, int positionInBuffer, UploadResult result) throws IOException, InterruptedException {
        PDU p1 = new PDU(this.msgOut, this.PDUstartOut);
        p1.constructDoUpload(uploadID);
        int res = this.exchange(p1);
        S7BaseConnection.checkResult(res);
        PDU p2 = new PDU(this.msgIn, this.PDUstartIn);
        res = p2.setupReceivedPDU();
        S7BaseConnection.checkResult(res);
        res = p2.testDoUploadResult();
        S7BaseConnection.checkResult(res);
        if (p2.dlen == 0) {
            S7BaseConnection.checkResult(-124);
        }
        int more = Nodave.USByte(p2.mem, p2.param + 1);
        int netLen = Nodave.USBEWord(p2.mem, p2.data);
        System.arraycopy(p2.mem, p2.data + 4, buffer, positionInBuffer, netLen);
        result.hasMore = more == 1;
        result.length = netLen;
    }

    public void endUpload(int uploadID) throws IOException, InterruptedException {
        PDU p1 = new PDU(this.msgOut, this.PDUstartOut);
        p1.constructEndUpload(uploadID);
        int res = this.exchange(p1);
        S7BaseConnection.checkResult(res);
        PDU p2 = new PDU(this.msgIn, this.PDUstartIn);
        res = p2.setupReceivedPDU();
        S7BaseConnection.checkResult(res);
        res = p2.testEndUploadResult();
        S7BaseConnection.checkResult(res);
    }

    public byte[] getProgramBlock(DaveArea area, int dbNum, int start, int len) throws InterruptedException, IOException {
        byte[] result = new byte[len];
        int uploadID = Integer.MIN_VALUE;
        try {
            this.semaphore.acquire();
            BlockInfo blockInfo = new BlockInfo();
            this.getBlockInfo(area, dbNum, blockInfo);
            byte[] buffer = new byte[(int)blockInfo.lengthLoadMemory];
            uploadID = this.initUpload(area, dbNum);
            int totLen = 0;
            UploadResult uploadResult = new UploadResult();
            do {
                this.doUpload(uploadID, buffer, totLen, uploadResult);
                totLen += uploadResult.length;
            } while (uploadResult.hasMore);
            int metadataSize = (int)blockInfo.lengthLoadMemory - blockInfo.mc7CodeLength;
            System.arraycopy(buffer, start + metadataSize, result, 0, len);
        }
        finally {
            if (uploadID != Integer.MIN_VALUE) {
                try {
                    this.endUpload(uploadID);
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
            this.semaphore.release();
        }
        return result;
    }
}

