/*
 * Decompiled with CFR 0.152.
 */
package com.github.s7connector.impl.nodave;

import com.github.s7connector.impl.nodave.Nodave;
import com.github.s7connector.impl.nodave.PDU;
import com.github.s7connector.impl.nodave.PLCinterface;
import com.github.s7connector.impl.nodave.S7Connection;
import java.io.IOException;

public final class TCPConnection
extends S7Connection {
    int rack;
    int slot;

    public TCPConnection(PLCinterface ifa, int rack, int slot) {
        super(ifa);
        this.rack = rack;
        this.slot = slot;
        this.PDUstartIn = 7;
        this.PDUstartOut = 7;
    }

    public int connectPLC() throws IOException, InterruptedException {
        byte[] byArray = new byte[18];
        byArray[0] = 17;
        byArray[1] = -32;
        byArray[5] = 1;
        byArray[7] = -63;
        byArray[8] = 2;
        byArray[9] = 1;
        byArray[11] = -62;
        byArray[12] = 2;
        byArray[13] = 1;
        byArray[14] = 2;
        byArray[15] = -64;
        byArray[16] = 1;
        byArray[17] = 9;
        byte[] b4 = byArray;
        System.arraycopy(b4, 0, this.msgOut, 4, b4.length);
        this.msgOut[17] = (byte)(this.rack + 1);
        this.msgOut[18] = (byte)this.slot;
        this.sendISOPacket(b4.length);
        this.readISOPacket();
        return this.negPDUlengthRequest();
    }

    @Override
    public int exchange(PDU p1) throws IOException, InterruptedException {
        this.msgOut[4] = 2;
        this.msgOut[5] = -16;
        this.msgOut[6] = -128;
        this.sendISOPacket(3 + p1.hlen + p1.plen + p1.dlen);
        this.readISOPacket();
        return 0;
    }

    protected int readISOPacket() throws IOException, InterruptedException {
        int res = this.iface.read(this.msgIn, 0, 4);
        if (res != 4) {
            return 0;
        }
        int len = Nodave.USBEWord(this.msgIn, 2);
        return res += this.iface.read(this.msgIn, 4, len);
    }

    protected int sendISOPacket(int size) throws IOException {
        this.msgOut[0] = 3;
        this.msgOut[1] = 0;
        this.msgOut[2] = (byte)((size += 4) / 256);
        this.msgOut[3] = (byte)(size % 256);
        this.iface.write(this.msgOut, 0, size);
        return 0;
    }
}

