/*
 * Decompiled with CFR 0.152.
 */
package com.github.s7connector.impl.serializer;

import com.github.s7connector.api.DaveArea;
import com.github.s7connector.api.S7Connector;
import com.github.s7connector.api.S7Serializer;
import com.github.s7connector.exception.S7Exception;
import com.github.s7connector.impl.serializer.parser.BeanEntry;
import com.github.s7connector.impl.serializer.parser.BeanParseResult;
import com.github.s7connector.impl.serializer.parser.BeanParser;
import java.lang.reflect.Array;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class S7SerializerImpl
implements S7Serializer {
    private static final Logger logger = LoggerFactory.getLogger(S7SerializerImpl.class);
    private final S7Connector connector;

    public static <T> T extractBytes(Class<T> beanClass, byte[] buffer, int byteOffset) {
        logger.trace("Extracting type {} from buffer with size: {} at offset {}", new Object[]{beanClass.getName(), buffer.length, byteOffset});
        try {
            T obj = beanClass.newInstance();
            BeanParseResult result = BeanParser.parse(beanClass);
            for (BeanEntry entry : result.entries) {
                Object value = null;
                if (entry.isArray) {
                    value = Array.newInstance(entry.type, entry.arraySize);
                    int i = 0;
                    while (i < entry.arraySize) {
                        Object component = entry.serializer.extract(entry.type, buffer, entry.byteOffset + byteOffset + i * entry.s7type.getByteSize(), entry.bitOffset + i * entry.s7type.getBitSize());
                        Array.set(value, i, component);
                        ++i;
                    }
                } else {
                    value = entry.serializer.extract(entry.type, buffer, entry.byteOffset + byteOffset, entry.bitOffset);
                }
                entry.field.set(obj, value);
            }
            return obj;
        }
        catch (Exception e) {
            throw new S7Exception("extractBytes", e);
        }
    }

    public static void insertBytes(Object bean, byte[] buffer, int byteOffset) {
        logger.trace("Inerting buffer with size: {} at offset {} into bean: {}", new Object[]{buffer.length, byteOffset, bean});
        try {
            BeanParseResult result = BeanParser.parse(bean);
            for (BeanEntry entry : result.entries) {
                Object fieldValue = entry.field.get(bean);
                if (fieldValue == null) continue;
                if (entry.isArray) {
                    int i = 0;
                    while (i < entry.arraySize) {
                        Object arrayItem = Array.get(fieldValue, i);
                        if (arrayItem != null) {
                            entry.serializer.insert(arrayItem, buffer, entry.byteOffset + byteOffset + i * entry.s7type.getByteSize(), entry.bitOffset + i * entry.s7type.getBitSize(), entry.size);
                        }
                        ++i;
                    }
                    continue;
                }
                entry.serializer.insert(fieldValue, buffer, entry.byteOffset + byteOffset, entry.bitOffset, entry.size);
            }
        }
        catch (Exception e) {
            throw new S7Exception("insertBytes", e);
        }
    }

    public S7SerializerImpl(S7Connector connector) {
        this.connector = connector;
    }

    @Override
    public synchronized <T> T dispense(Class<T> beanClass, int dbNum, int byteOffset) throws S7Exception {
        try {
            BeanParseResult result = BeanParser.parse(beanClass);
            byte[] buffer = this.connector.read(DaveArea.DB, dbNum, result.blockSize, byteOffset);
            return S7SerializerImpl.extractBytes(beanClass, buffer, 0);
        }
        catch (Exception e) {
            throw new S7Exception("dispense", e);
        }
    }

    @Override
    public synchronized <T> T dispense(Class<T> beanClass, int dbNum, int byteOffset, int blockSize) throws S7Exception {
        try {
            byte[] buffer = this.connector.read(DaveArea.DB, dbNum, blockSize, byteOffset);
            return S7SerializerImpl.extractBytes(beanClass, buffer, 0);
        }
        catch (Exception e) {
            throw new S7Exception("dispense dbnum(" + dbNum + ") byteoffset(" + byteOffset + ") blocksize(" + blockSize + ")", e);
        }
    }

    @Override
    public synchronized void store(Object bean, int dbNum, int byteOffset) {
        try {
            BeanParseResult result = BeanParser.parse(bean);
            byte[] buffer = new byte[result.blockSize];
            logger.trace("store-buffer-size: " + buffer.length);
            S7SerializerImpl.insertBytes(bean, buffer, 0);
            this.connector.write(DaveArea.DB, dbNum, byteOffset, buffer);
        }
        catch (Exception e) {
            throw new S7Exception("store", e);
        }
    }
}

