/*
 * Decompiled with CFR 0.152.
 */
package com.github.s7connector.impl.serializer.converter;

import com.github.s7connector.api.S7Serializable;
import com.github.s7connector.impl.utils.S7Type;

public final class BitConverter
implements S7Serializable {
    @Override
    public <T> T extract(Class<T> targetClass, byte[] buffer, int byteOffset, int bitOffset) {
        byte bufValue = buffer[byteOffset];
        return targetClass.cast(bufValue == (bufValue | 1 << bitOffset));
    }

    @Override
    public S7Type getS7Type() {
        return S7Type.BOOL;
    }

    @Override
    public int getSizeInBits() {
        return 1;
    }

    @Override
    public int getSizeInBytes() {
        return 0;
    }

    @Override
    public void insert(Object javaType, byte[] buffer, int byteOffset, int bitOffset, int size) {
        Boolean value = (Boolean)javaType;
        if (value.booleanValue()) {
            byte bufValue = buffer[byteOffset];
            buffer[byteOffset] = bufValue = (byte)(bufValue | 1 << bitOffset);
        }
    }
}

