/*
 * Decompiled with CFR 0.152.
 */
package com.github.s7connector.impl.serializer.converter;

import com.github.s7connector.impl.serializer.converter.ByteConverter;
import com.github.s7connector.impl.utils.S7Type;
import java.util.Calendar;
import java.util.Date;

public final class DateAndTimeConverter
extends ByteConverter {
    public static final int OFFSET_DAY = 2;
    public static final int OFFSET_HOUR = 3;
    public static final int OFFSET_MILLIS_1_AND_DOW = 7;
    public static final int OFFSET_MILLIS_100_10 = 6;
    public static final int OFFSET_MINUTE = 4;
    public static final int OFFSET_MONTH = 1;
    public static final int OFFSET_SECOND = 5;
    public static final int OFFSET_YEAR = 0;

    @Override
    public <T> T extract(Class<T> targetClass, byte[] buffer, int byteOffset, int bitOffset) {
        Calendar c = Calendar.getInstance();
        c.clear();
        int year = this.getFromPLC(buffer, 0 + byteOffset);
        year = year < 90 ? (year += 2000) : (year += 1900);
        int month = this.getFromPLC(buffer, 1 + byteOffset);
        if (month > 0) {
            --month;
        }
        c.set(1, year);
        c.set(2, month);
        c.set(5, this.getFromPLC(buffer, 2 + byteOffset));
        c.set(11, this.getFromPLC(buffer, 3 + byteOffset));
        c.set(12, this.getFromPLC(buffer, 4 + byteOffset));
        c.set(13, this.getFromPLC(buffer, 5 + byteOffset));
        return targetClass.cast(c.getTime());
    }

    public byte getFromPLC(byte[] buffer, int offset) {
        try {
            byte ret = super.extract(Byte.class, buffer, offset, 0);
            return (byte)Integer.parseInt(Integer.toHexString(ret & 0xFF));
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    @Override
    public S7Type getS7Type() {
        return S7Type.DATE_AND_TIME;
    }

    @Override
    public int getSizeInBits() {
        return 0;
    }

    @Override
    public int getSizeInBytes() {
        return 8;
    }

    @Override
    public void insert(Object javaType, byte[] buffer, int byteOffset, int bitOffset, int size) {
        Date date = (Date)javaType;
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int year = c.get(1);
        year = year < 2000 ? (year -= 1900) : (year -= 2000);
        this.putToPLC(buffer, byteOffset + 0, year);
        this.putToPLC(buffer, byteOffset + 1, c.get(2) + 1);
        this.putToPLC(buffer, byteOffset + 2, c.get(5));
        this.putToPLC(buffer, byteOffset + 3, c.get(11));
        this.putToPLC(buffer, byteOffset + 4, c.get(12));
        this.putToPLC(buffer, byteOffset + 5, c.get(13));
    }

    public void putToPLC(byte[] buffer, int offset, int i) {
        try {
            int ret = Integer.parseInt("" + i, 16);
            buffer[offset] = (byte)ret;
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
    }
}

