/*
 * Decompiled with CFR 0.152.
 */
package com.github.s7connector.impl.serializer.converter;

import com.github.s7connector.impl.serializer.converter.IntegerConverter;
import com.github.s7connector.impl.utils.S7Type;
import java.util.Calendar;
import java.util.Date;

public final class DateConverter
extends IntegerConverter {
    private static final long MILLI_TO_DAY_FACTOR = 86400000L;
    private static final long OFFSET_1990;

    static {
        Calendar c = Calendar.getInstance();
        c.clear();
        c.set(11, 0);
        c.set(1, 1990);
        OFFSET_1990 = c.getTime().getTime();
    }

    @Override
    public <T> T extract(Class<T> targetClass, byte[] buffer, int byteOffset, int bitOffset) {
        long days = super.extract(Integer.class, buffer, byteOffset, bitOffset).intValue();
        long millis = days * 86400000L;
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(millis += OFFSET_1990);
        c.set(14, 0);
        c.set(13, 0);
        c.set(12, 0);
        c.set(11, 0);
        return targetClass.cast(c.getTime());
    }

    @Override
    public S7Type getS7Type() {
        return S7Type.DATE;
    }

    @Override
    public void insert(Object javaType, byte[] buffer, int byteOffset, int bitOffset, int size) {
        long actual;
        Date d = (Date)javaType;
        long millis = d.getTime();
        double days = (double)(millis -= OFFSET_1990) / 8.64E7;
        long expected = (long)(days * 8.64E7 / 1000.0);
        if (expected != (actual = millis / 1000L)) {
            throw new IllegalArgumentException("Expected: " + expected + " got: " + actual);
        }
        if (millis < 0L) {
            super.insert(0, buffer, byteOffset, bitOffset, 2);
        } else {
            super.insert((int)Math.round(days), buffer, byteOffset, bitOffset, 2);
        }
    }
}

