/*
 * Decompiled with CFR 0.152.
 */
package com.github.s7connector.impl.serializer.converter;

import com.github.s7connector.api.S7Serializable;
import com.github.s7connector.impl.utils.S7Type;

public class IntegerConverter
implements S7Serializable {
    private static final int OFFSET_HIGH_BYTE = 0;
    private static final int OFFSET_LOW_BYTE = 1;

    @Override
    public <T> T extract(Class<T> targetClass, byte[] buffer, int byteOffset, int bitOffset) {
        byte lower = buffer[byteOffset + 1];
        byte higher = buffer[byteOffset + 0];
        Integer i = lower & 0xFF | higher << 8 & 0xFF00;
        return targetClass.cast(i);
    }

    @Override
    public S7Type getS7Type() {
        return S7Type.WORD;
    }

    @Override
    public int getSizeInBits() {
        return 0;
    }

    @Override
    public int getSizeInBytes() {
        return 2;
    }

    @Override
    public void insert(Object javaType, byte[] buffer, int byteOffset, int bitOffset, int size) {
        Integer value = (Integer)javaType;
        byte lower = (byte)(value >> 0 & 0xFF);
        byte higher = (byte)(value >> 8 & 0xFF);
        buffer[byteOffset + 1] = lower;
        buffer[byteOffset + 0] = higher;
    }
}

