/*
 * Decompiled with CFR 0.152.
 */
package com.github.s7connector.impl.serializer.converter;

import com.github.s7connector.api.S7Serializable;
import com.github.s7connector.impl.utils.S7Type;

public final class LongConverter
implements S7Serializable {
    @Override
    public <T> T extract(Class<T> targetClass, byte[] buffer, int byteOffset, int bitOffset) {
        byte b1 = buffer[byteOffset + 0];
        byte b2 = buffer[byteOffset + 1];
        byte b3 = buffer[byteOffset + 2];
        byte b4 = buffer[byteOffset + 3];
        Integer i = b4 << 0 & 0xFF | b3 << 8 & 0xFF00 | b2 << 16 & 0xFF0000 | b1 << 24 & 0xFF000000;
        return targetClass.cast(i.longValue());
    }

    @Override
    public S7Type getS7Type() {
        return S7Type.WORD;
    }

    @Override
    public int getSizeInBits() {
        return 0;
    }

    @Override
    public int getSizeInBytes() {
        return 4;
    }

    @Override
    public void insert(Object javaType, byte[] buffer, int byteOffset, int bitOffset, int size) {
        byte b1;
        Long value = (Long)javaType;
        byte b4 = (byte)(value >> 0 & 0xFFL);
        byte b3 = (byte)(value >> 8 & 0xFFL);
        byte b2 = (byte)(value >> 16 & 0xFFL);
        buffer[byteOffset + 0] = b1 = (byte)(value >> 24 & 0xFFL);
        buffer[byteOffset + 1] = b2;
        buffer[byteOffset + 2] = b3;
        buffer[byteOffset + 3] = b4;
    }
}

