/*
 * Decompiled with CFR 0.152.
 */
package com.github.s7connector.impl.serializer.converter;

import com.github.s7connector.api.S7Serializable;
import com.github.s7connector.impl.utils.S7Type;

public final class RealConverter
implements S7Serializable {
    private static final int OFFSET_POS1 = 0;
    private static final int OFFSET_POS2 = 1;
    private static final int OFFSET_POS3 = 2;
    private static final int OFFSET_POS4 = 3;

    @Override
    public <T> T extract(Class<T> targetClass, byte[] buffer, int byteOffset, int bitOffset) {
        Float fValue;
        int iValue = (buffer[byteOffset + 3] & 0xFF) << 0 | (buffer[byteOffset + 2] & 0xFF) << 8 | (buffer[byteOffset + 1] & 0xFF) << 16 | (buffer[byteOffset + 0] & 0xFF) << 24;
        Number ret = fValue = Float.valueOf(Float.intBitsToFloat(iValue));
        if (targetClass == Double.class) {
            ret = Double.parseDouble(fValue.toString());
        }
        return targetClass.cast(ret);
    }

    @Override
    public S7Type getS7Type() {
        return S7Type.REAL;
    }

    @Override
    public int getSizeInBits() {
        return 0;
    }

    @Override
    public int getSizeInBytes() {
        return 4;
    }

    @Override
    public void insert(Object javaType, byte[] buffer, int byteOffset, int bitOffset, int size) {
        float fValue = Float.parseFloat(javaType.toString());
        int iValue = Float.floatToIntBits(fValue);
        buffer[byteOffset + 3] = (byte)(iValue >> 0 & 0xFF);
        buffer[byteOffset + 2] = (byte)(iValue >> 8 & 0xFF);
        buffer[byteOffset + 1] = (byte)(iValue >> 16 & 0xFF);
        buffer[byteOffset + 0] = (byte)(iValue >> 24 & 0xFF);
    }
}

