/*
 * Decompiled with CFR 0.152.
 */
package com.github.s7connector.impl.serializer.converter;

import com.github.s7connector.api.S7Serializable;
import com.github.s7connector.impl.utils.S7Type;

public final class StringConverter
implements S7Serializable {
    private static final int OFFSET_CURRENT_LENGTH = 1;
    private static final int OFFSET_OVERALL_LENGTH = 0;
    private static final int OFFSET_START = 2;

    @Override
    public <T> T extract(Class<T> targetClass, byte[] buffer, int byteOffset, int bitOffset) {
        int len = buffer[byteOffset + 1];
        byte[] bytes = new byte[len];
        int i = 0;
        while (i < len) {
            bytes[i] = buffer[byteOffset + 2 + i];
            ++i;
        }
        return targetClass.cast(new String(bytes));
    }

    @Override
    public S7Type getS7Type() {
        return S7Type.STRING;
    }

    @Override
    public int getSizeInBits() {
        return 0;
    }

    @Override
    public int getSizeInBytes() {
        return 2;
    }

    @Override
    public void insert(Object javaType, byte[] buffer, int byteOffset, int bitOffset, int size) {
        String value = (String)javaType;
        int len = value.length();
        if (len > size) {
            throw new IllegalArgumentException("String to big: " + len);
        }
        buffer[byteOffset + 0] = (byte)size;
        buffer[byteOffset + 1] = (byte)len;
        byte[] strBytes = value.getBytes();
        int i = 0;
        while (i < len) {
            buffer[byteOffset + 2 + i] = (byte)(strBytes[i] & 0xFF);
            ++i;
        }
    }
}

