/*
 * Decompiled with CFR 0.152.
 */
package com.github.s7connector.impl.serializer.converter;

import com.github.s7connector.impl.serializer.converter.ByteConverter;
import com.github.s7connector.impl.utils.S7Type;

public final class TimeConverter
extends ByteConverter {
    @Override
    public <T> T extract(Class<T> targetClass, byte[] buffer, int byteOffset, int bitOffset) {
        byte b1 = super.extract(Byte.class, buffer, byteOffset + 3, bitOffset);
        byte b2 = super.extract(Byte.class, buffer, byteOffset + 2, bitOffset);
        byte b3 = super.extract(Byte.class, buffer, byteOffset + 1, bitOffset);
        byte b4 = super.extract(Byte.class, buffer, byteOffset + 0, bitOffset);
        long l = ((long)b1 & 0xFFL) << 0 | ((long)b2 & 0xFFL) << 8 | ((long)b3 & 0xFFL) << 16 | ((long)b4 & 0xFFL) << 24;
        return targetClass.cast(l);
    }

    @Override
    public S7Type getS7Type() {
        return S7Type.TIME;
    }

    @Override
    public int getSizeInBytes() {
        return 4;
    }

    @Override
    public void insert(Object javaType, byte[] buffer, int byteOffset, int bitOffset, int size) {
        long l = (Long)javaType;
        byte b1 = (byte)((byte)(l >> 0) & 0xFF);
        byte b2 = (byte)((byte)(l >> 8) & 0xFF);
        byte b3 = (byte)((byte)(l >> 16) & 0xFF);
        byte b4 = (byte)((byte)(l >> 24) & 0xFF);
        super.insert(b1, buffer, byteOffset + 3, bitOffset, 1);
        super.insert(b2, buffer, byteOffset + 2, bitOffset, 1);
        super.insert(b3, buffer, byteOffset + 1, bitOffset, 1);
        super.insert(b4, buffer, byteOffset + 0, bitOffset, 1);
    }
}

