/*
 * Decompiled with CFR 0.152.
 */
package com.github.s7connector.impl.serializer.parser;

import com.github.s7connector.api.S7Serializable;
import com.github.s7connector.api.annotation.S7Variable;
import com.github.s7connector.impl.serializer.parser.BeanEntry;
import com.github.s7connector.impl.serializer.parser.BeanParseResult;
import com.github.s7connector.impl.utils.S7Type;
import java.lang.reflect.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BeanParser {
    private static final Logger logger = LoggerFactory.getLogger(BeanParser.class);

    private static Class<?> getWrapperForPrimitiveType(Class<?> primitiveType) {
        if (primitiveType == Boolean.TYPE) {
            return Boolean.class;
        }
        if (primitiveType == Byte.TYPE) {
            return Byte.class;
        }
        if (primitiveType == Integer.TYPE) {
            return Integer.class;
        }
        if (primitiveType == Float.TYPE) {
            return Float.class;
        }
        if (primitiveType == Double.TYPE) {
            return Double.class;
        }
        if (primitiveType == Long.TYPE) {
            return Long.class;
        }
        return primitiveType;
    }

    public static BeanParseResult parse(Class<?> jclass) throws Exception {
        BeanParseResult res = new BeanParseResult();
        logger.trace("Parsing: " + jclass.getName());
        Field[] fieldArray = jclass.getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            S7Variable dataAnnotation = field.getAnnotation(S7Variable.class);
            if (dataAnnotation != null) {
                S7Serializable s;
                logger.trace("Parsing field: " + field.getName());
                logger.trace("\t\ttype: " + (Object)((Object)dataAnnotation.type()));
                logger.trace("\t\tbyteOffset: " + dataAnnotation.byteOffset());
                logger.trace("\t\tbitOffset: " + dataAnnotation.bitOffset());
                logger.trace("\t\tsize: " + dataAnnotation.size());
                logger.trace("\t\tarraySize: " + dataAnnotation.arraySize());
                int offset = dataAnnotation.byteOffset();
                if (offset > res.blockSize) {
                    res.blockSize = offset;
                }
                if (dataAnnotation.type() == S7Type.STRUCT) {
                    logger.trace("Recursing...");
                    BeanParseResult subResult = BeanParser.parse(field.getType());
                    res.blockSize += subResult.blockSize;
                    logger.trace("\tNew blocksize: " + res.blockSize);
                }
                logger.trace("\tNew blocksize (+offset): " + res.blockSize);
                res.blockSize += dataAnnotation.size();
                BeanEntry entry = new BeanEntry();
                entry.byteOffset = dataAnnotation.byteOffset();
                entry.bitOffset = dataAnnotation.bitOffset();
                entry.field = field;
                entry.type = BeanParser.getWrapperForPrimitiveType(field.getType());
                entry.size = dataAnnotation.size();
                entry.s7type = dataAnnotation.type();
                entry.isArray = field.getType().isArray();
                entry.arraySize = dataAnnotation.arraySize();
                if (entry.isArray) {
                    entry.type = BeanParser.getWrapperForPrimitiveType(entry.type.getComponentType());
                }
                entry.serializer = s = entry.s7type.getSerializer().newInstance();
                res.blockSize += s.getSizeInBytes() * dataAnnotation.arraySize();
                logger.trace("\tNew blocksize (+array): " + res.blockSize);
                if (s.getSizeInBits() > 0) {
                    boolean offsetOfBitAlreadyKnown = false;
                    for (BeanEntry parsedEntry : res.entries) {
                        if (parsedEntry.byteOffset != entry.byteOffset) continue;
                        offsetOfBitAlreadyKnown = true;
                    }
                    if (!offsetOfBitAlreadyKnown) {
                        ++res.blockSize;
                    }
                }
                res.entries.add(entry);
            }
            ++n2;
        }
        logger.trace("Parsing done, overall size: " + res.blockSize);
        return res;
    }

    public static BeanParseResult parse(Object obj) throws Exception {
        return BeanParser.parse(obj.getClass());
    }
}

