/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.richtextarea;

import com.gluonhq.richtextarea.model.ParagraphDecoration;
import java.util.function.BiFunction;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Rectangle;

public class DefaultParagraphGraphicFactory {
    public static BiFunction<Integer, ParagraphDecoration.GraphicType, Node> getFactory() {
        return (indent, type) -> {
            if (type == null) {
                return null;
            }
            switch (type) {
                case NUMBERED_LIST: {
                    Label label = new Label("#.");
                    label.getStyleClass().add((Object)"numbered-list-label");
                    return label;
                }
                case BULLETED_LIST: {
                    if (indent == 0) {
                        return null;
                    }
                    switch ((indent - 1) % 4 + 1) {
                        case 1: {
                            Circle circle1 = new Circle(2.0);
                            circle1.getStyleClass().add((Object)"bulleted-list-shape-1");
                            return circle1;
                        }
                        case 2: {
                            Circle circle2 = new Circle(2.0);
                            circle2.getStyleClass().add((Object)"bulleted-list-shape-2");
                            return circle2;
                        }
                        case 3: {
                            Rectangle rectangle3 = new Rectangle(4.0, 4.0);
                            rectangle3.getStyleClass().add((Object)"bulleted-list-shape-3");
                            return rectangle3;
                        }
                        case 4: {
                            Rectangle rectangle4 = new Rectangle(4.0, 4.0);
                            rectangle4.getStyleClass().add((Object)"bulleted-list-shape-4");
                            return rectangle4;
                        }
                    }
                }
            }
            return null;
        };
    }
}

