/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.richtextarea;

import com.gluonhq.richtextarea.BackgroundColorPath;
import com.gluonhq.richtextarea.IndexRangeColor;
import com.gluonhq.richtextarea.RichTextArea;
import com.gluonhq.richtextarea.RichTextAreaSkin;
import com.gluonhq.richtextarea.Selection;
import com.gluonhq.richtextarea.Tools;
import com.gluonhq.richtextarea.model.Paragraph;
import com.gluonhq.richtextarea.model.ParagraphDecoration;
import com.gluonhq.richtextarea.viewmodel.RichTextAreaViewModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ObservableSet;
import javafx.collections.SetChangeListener;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseDragEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.RowConstraints;
import javafx.scene.paint.Paint;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.Shape;
import javafx.scene.text.Font;
import javafx.scene.text.HitInfo;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.text.TextFlow;
import javafx.util.Duration;

public class ParagraphTile
extends HBox {
    private static final double INDENT_PADDING = 20.0;
    private Paragraph paragraph;
    private final HBox graphicBox;
    private final Pane contentPane;
    private final List<Layer> layers;
    private final RichTextArea control;
    private final RichTextAreaSkin richTextAreaSkin;
    private final RichTextAreaViewModel viewModel;
    private final ChangeListener<Number> caretPositionListener = (o, ocp, p) -> this.updateCaretPosition(p.intValue());
    private final ChangeListener<Selection> selectionListener = (o, os, selection) -> this.updateSelection((Selection)selection);

    public ParagraphTile(RichTextAreaSkin richTextAreaSkin) {
        this.richTextAreaSkin = richTextAreaSkin;
        this.control = (RichTextArea)richTextAreaSkin.getSkinnable();
        this.viewModel = richTextAreaSkin.getViewModel();
        this.getStyleClass().setAll((Object[])new String[]{"paragraph-tile"});
        this.contentPane = new Pane();
        this.contentPane.setPadding(new Insets(1.0));
        this.contentPane.getStyleClass().setAll((Object[])new String[]{"content-area"});
        this.layers = new ArrayList<Layer>();
        this.graphicBox = new HBox();
        this.graphicBox.getStyleClass().add((Object)"graphic-box");
        this.graphicBox.setAlignment(Pos.TOP_RIGHT);
        this.getChildren().addAll((Object[])new Node[]{this.graphicBox, this.contentPane});
        this.setSpacing(0.0);
    }

    void setParagraph(Paragraph paragraph, List<Node> fragments, List<Integer> positions, List<IndexRangeColor> background) {
        this.layers.forEach(Layer::reset);
        this.layers.clear();
        this.graphicBox.getChildren().clear();
        this.contentPane.getChildren().clear();
        this.viewModel.caretPositionProperty().removeListener(this.caretPositionListener);
        this.viewModel.selectionProperty().removeListener(this.selectionListener);
        this.paragraph = paragraph;
        if (paragraph == null) {
            this.contentPane.setPrefWidth(0.0);
            return;
        }
        ParagraphDecoration decoration = paragraph.getDecoration();
        this.viewModel.caretPositionProperty().addListener(this.caretPositionListener);
        this.viewModel.selectionProperty().addListener(this.selectionListener);
        if (decoration.hasTableDecoration()) {
            if (!fragments.isEmpty()) {
                HBox gridBox = this.createGridBox(fragments, positions, background, decoration);
                this.contentPane.getChildren().add((Object)gridBox);
                this.contentPane.layout();
            }
        } else {
            Layer layer = new Layer(paragraph.getStart(), paragraph.getEnd(), false);
            layer.setContent(fragments, background, decoration);
            this.layers.add(layer);
            this.contentPane.getChildren().add((Object)layer);
            this.updateGraphicBox(layer, this.control.getParagraphGraphicFactory());
            this.graphicBox.setPadding(new Insets(decoration.getTopInset(), 2.0, decoration.getBottomInset(), 0.0));
            this.contentPane.layout();
        }
    }

    private HBox createGridBox(List<Node> fragments, List<Integer> positions, List<IndexRangeColor> background, ParagraphDecoration decoration) {
        GridPane grid = new GridPane();
        grid.getStyleClass().add((Object)"table");
        int r = decoration.getTableDecoration().getRows();
        int c = decoration.getTableDecoration().getColumns();
        TextAlignment[][] ta = decoration.getTableDecoration().getCellAlignment();
        int j = 0;
        while (j < c) {
            ColumnConstraints cc = new ColumnConstraints();
            cc.setPercentWidth(100.0 / (double)c);
            grid.getColumnConstraints().add((Object)cc);
            ++j;
        }
        int index = 0;
        int i = 0;
        while (i < r) {
            double prefHeight = 0.0;
            int j2 = 0;
            while (j2 < c) {
                if (index + 1 >= positions.size()) break;
                Layer layer = new Layer(positions.get(index), positions.get(index + 1), true);
                ParagraphDecoration pd = ParagraphDecoration.builder().fromDecoration(decoration).alignment(ta[i][j2]).build();
                int tableIndex = index++;
                layer.setContent(fragments.stream().filter(n2 -> {
                    int p = (Integer)n2.getProperties().getOrDefault((Object)"table_separator", (Object)-1);
                    return (Integer)positions.get(tableIndex) <= p && p < (Integer)positions.get(tableIndex + 1);
                }).collect(Collectors.toList()), background, pd);
                layer.updatePrefWidth(100.0);
                this.layers.add(layer);
                grid.add((Node)layer, j2, i);
                prefHeight = Math.max(prefHeight, layer.prefHeight(100.0));
                ++j2;
            }
            RowConstraints rc = new RowConstraints();
            rc.setMinHeight(prefHeight);
            rc.setMaxHeight(Double.MAX_VALUE);
            grid.getRowConstraints().add((Object)rc);
            ++i;
        }
        HBox gridBox = new HBox(new Node[]{grid});
        gridBox.setPrefHeight(grid.getPrefHeight() + 1.0);
        gridBox.setPrefWidth(this.richTextAreaSkin.textFlowPrefWidthProperty.get());
        gridBox.setAlignment(decoration.getAlignment().equals((Object)TextAlignment.LEFT) ? Pos.TOP_LEFT : (decoration.getAlignment().equals((Object)TextAlignment.RIGHT) ? Pos.TOP_RIGHT : Pos.TOP_CENTER));
        return gridBox;
    }

    private void updateGraphicBox(Layer layer, BiFunction<Integer, ParagraphDecoration.GraphicType, Node> graphicFactory) {
        ParagraphDecoration decoration = this.paragraph.getDecoration();
        int indentationLevel = decoration.getIndentationLevel();
        Node graphicNode = null;
        if (graphicFactory != null) {
            graphicNode = graphicFactory.apply(indentationLevel, decoration.getGraphicType());
        }
        double spanPrefWidth = Math.max((double)(indentationLevel - (graphicNode == null ? 0 : 1)) * 20.0, 0.0);
        if (graphicNode == null) {
            this.graphicBox.setMinWidth(spanPrefWidth);
            this.graphicBox.setMaxWidth(spanPrefWidth);
            layer.updatePrefWidth(this.richTextAreaSkin.textFlowPrefWidthProperty.get() - spanPrefWidth);
            return;
        }
        this.graphicBox.getChildren().add((Object)graphicNode);
        double nodePrefWidth = 0.0;
        double nodePrefHeight = 0.0;
        if (graphicNode instanceof Label) {
            Label numberedListLabel = (Label)graphicNode;
            String text = numberedListLabel.getText();
            if (text != null) {
                if (text.contains("#")) {
                    AtomicInteger ordinal = new AtomicInteger();
                    this.viewModel.getParagraphList().stream().peek(p -> {
                        if (p.getDecoration().getGraphicType() != ParagraphDecoration.GraphicType.NUMBERED_LIST || p.getDecoration().getIndentationLevel() != indentationLevel) {
                            ordinal.set(0);
                        } else {
                            ordinal.incrementAndGet();
                        }
                    }).filter(p -> this.paragraph.equals(p)).findFirst().ifPresent(p -> numberedListLabel.setText(text.replace("#", "" + ordinal.get())));
                }
                Font font = layer.getFont();
                numberedListLabel.setFont(font);
                double w = Tools.computeStringWidth(font, numberedListLabel.getText());
                nodePrefWidth = Math.max(w + 1.0, 20.0);
                nodePrefHeight = Tools.computeStringHeight(font, numberedListLabel.getText());
            }
        } else {
            nodePrefWidth = Math.max(graphicNode.prefWidth(-1.0), 20.0);
            nodePrefHeight = graphicNode.prefHeight(nodePrefWidth);
        }
        graphicNode.setTranslateY(Math.max(0.0, (layer.getCaretY() - nodePrefHeight) / 2.0));
        double boxPrefWidth = spanPrefWidth + nodePrefWidth;
        this.graphicBox.setMinWidth(boxPrefWidth);
        this.graphicBox.setMaxWidth(boxPrefWidth);
        layer.updatePrefWidth(this.richTextAreaSkin.textFlowPrefWidthProperty.get() - boxPrefWidth);
    }

    void mousePressedListener(MouseEvent e) {
        if (this.control.isDisabled()) {
            return;
        }
        this.layers.forEach(l -> {
            Point2D localEvent = l.screenToLocal(e.getScreenX(), e.getScreenY());
            if (l.getLayoutBounds().contains(localEvent)) {
                l.mousePressedListener(e);
            }
        });
    }

    void mouseDraggedListener(MouseEvent e) {
        this.layers.forEach(l -> {
            Point2D localEvent = l.screenToLocal(e.getScreenX(), e.getScreenY());
            if (e.getEventType() == MouseDragEvent.MOUSE_DRAG_OVER || l.isTableCell) {
                if (l.getLayoutBounds().contains(localEvent)) {
                    l.mouseDraggedListener(e);
                }
            } else if (e.getEventType() == MouseEvent.MOUSE_DRAGGED && l.getLayoutBounds().getMinY() <= localEvent.getY() && localEvent.getY() <= l.getLayoutBounds().getMaxY()) {
                l.mouseDraggedListener(e);
            }
        });
    }

    void evictUnusedObjects() {
        this.layers.forEach(Layer::evictUnusedObjects);
    }

    void updateLayout() {
        if (this.control == null || this.viewModel == null) {
            return;
        }
        this.layers.forEach(l -> {
            l.updateSelection(this.viewModel.getSelection());
            l.updateCaretPosition(this.viewModel.getCaretPosition());
        });
    }

    boolean hasCaret() {
        return this.layers.stream().anyMatch(Layer::hasCaret);
    }

    int getNextRowPosition(double x, boolean down) {
        return this.layers.stream().findFirst().map(l -> l.getNextRowPosition(x, down)).orElse(0);
    }

    private void updateCaretPosition(int caretPosition) {
        this.layers.forEach(l -> l.updateCaretPosition(caretPosition));
    }

    private void updateSelection(Selection selection) {
        this.layers.forEach(l -> l.updateSelection(selection));
    }

    private class Layer
    extends Pane {
        private final Timeline caretTimeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, e -> this.setCaretVisibility(false), new KeyValue[0]), new KeyFrame(Duration.seconds((double)0.5), e -> this.setCaretVisibility(true), new KeyValue[0]), new KeyFrame(Duration.seconds((double)1.0), new KeyValue[0])});
        private final ObservableSet<Path> textBackgroundColorPaths = FXCollections.observableSet((Object[])new Path[0]);
        private final Path caretShape = new Path();
        private final Path selectionShape = new Path();
        private final TextFlow textFlow = new TextFlow();
        private double textFlowLayoutX;
        private double textFlowLayoutY;
        private final int start;
        private final int end;
        private final boolean isTableCell;

        public Layer(int start, int end, boolean isTableCell) {
            this.start = start;
            this.end = end;
            this.isTableCell = isTableCell;
            this.caretTimeline.setCycleCount(-1);
            this.textFlow.setFocusTraversable(false);
            this.textFlow.getStyleClass().setAll((Object[])new String[]{"text-flow"});
            this.textFlow.setOnMousePressed(this::mousePressedListener);
            this.caretShape.setFocusTraversable(false);
            this.caretShape.getStyleClass().add((Object)"caret");
            this.selectionShape.getStyleClass().setAll((Object[])new String[]{"selection"});
            this.textBackgroundColorPaths.addListener(this::updateLayer);
            this.getChildren().addAll(this.textBackgroundColorPaths);
            this.getChildren().addAll((Object[])new Node[]{this.selectionShape, this.caretShape, this.textFlow});
            this.getStyleClass().add((Object)"layer");
        }

        protected double computePrefHeight(double width) {
            return this.textFlow.prefHeight(this.textFlow.getPrefWidth()) + 1.0;
        }

        protected double computePrefWidth(double height) {
            return this.textFlow.prefWidth(this.textFlow.getPrefHeight()) + 2.0;
        }

        void setContent(List<Node> fragments, List<IndexRangeColor> background, ParagraphDecoration decoration) {
            this.textFlow.getChildren().setAll(fragments);
            this.textFlow.setTextAlignment(decoration.getAlignment());
            this.textFlow.setLineSpacing(decoration.getSpacing());
            this.textFlow.setPadding(new Insets(decoration.getTopInset(), decoration.getRightInset(), decoration.getBottomInset(), decoration.getLeftInset()));
            this.textFlowLayoutX = 1.0 + decoration.getLeftInset();
            this.textFlowLayoutY = 1.0 + decoration.getTopInset();
            Platform.runLater(() -> this.addBackgroundPathsToLayers(background));
        }

        void reset() {
            this.caretTimeline.stop();
        }

        private void addBackgroundPathsToLayers(List<IndexRangeColor> backgroundIndexRanges) {
            Map fillPathMap = backgroundIndexRanges.stream().map(indexRangeBackground -> {
                BackgroundColorPath path = new BackgroundColorPath(this.textFlow.rangeShape(indexRangeBackground.getStart(), indexRangeBackground.getEnd()));
                path.setStrokeWidth(0.0);
                path.setFill((Paint)indexRangeBackground.getColor());
                path.setLayoutX(this.textFlowLayoutX);
                path.setLayoutY(this.textFlowLayoutY);
                return path;
            }).collect(Collectors.toMap(Shape::getFill, Function.identity(), (p1, p2) -> {
                Path union = (Path)Shape.union((Shape)p1, (Shape)p2);
                union.setFill(p1.getFill());
                return union;
            }));
            this.textBackgroundColorPaths.removeIf(path -> !fillPathMap.containsValue(path));
            this.textBackgroundColorPaths.addAll(fillPathMap.values());
        }

        void mousePressedListener(MouseEvent e) {
            Point2D localEvent = this.screenToLocal(e.getScreenX(), e.getScreenY());
            if (e.getButton() == MouseButton.PRIMARY && !e.isMiddleButtonDown() && !e.isSecondaryButtonDown()) {
                HitInfo hitInfo = this.textFlow.hitTest(new Point2D(localEvent.getX() - this.textFlowLayoutX, localEvent.getY() - this.textFlowLayoutY));
                Selection prevSelection = ParagraphTile.this.viewModel.getSelection();
                int prevCaretPosition = ParagraphTile.this.viewModel.getCaretPosition();
                int insertionIndex = hitInfo.getInsertionIndex();
                if (insertionIndex >= 0) {
                    int globalInsertionIndex = Math.min(this.start + insertionIndex, this.getParagraphLimit() - 1);
                    if (!(e.isControlDown() || e.isAltDown() || e.isShiftDown() || e.isMetaDown() || e.isShortcutDown())) {
                        ParagraphTile.this.viewModel.setCaretPosition(globalInsertionIndex);
                        if (e.getClickCount() == 2) {
                            ParagraphTile.this.viewModel.selectCurrentWord();
                        } else if (e.getClickCount() == 3) {
                            if (this.isTableCell) {
                                ParagraphTile.this.viewModel.setSelection(new Selection(this.start, this.end));
                            } else {
                                ParagraphTile.this.viewModel.selectCurrentParagraph();
                            }
                        } else {
                            ParagraphTile.this.richTextAreaSkin.mouseDragStart = globalInsertionIndex;
                            ParagraphTile.this.viewModel.clearSelection();
                        }
                    } else if (!(!e.isShiftDown() || e.getClickCount() != 1 || e.isControlDown() || e.isAltDown() || e.isMetaDown() || e.isShortcutDown())) {
                        int pos = prevSelection.isDefined() ? (globalInsertionIndex < prevSelection.getStart() ? prevSelection.getEnd() : prevSelection.getStart()) : prevCaretPosition;
                        ParagraphTile.this.viewModel.setSelection(new Selection(pos, globalInsertionIndex));
                        ParagraphTile.this.viewModel.setCaretPosition(globalInsertionIndex);
                    }
                }
                ParagraphTile.this.control.requestFocus();
                e.consume();
            }
            if (ParagraphTile.this.richTextAreaSkin.contextMenu.isShowing()) {
                ParagraphTile.this.richTextAreaSkin.contextMenu.hide();
            }
        }

        void mouseDraggedListener(MouseEvent e) {
            Point2D localEvent = this.screenToLocal(e.getScreenX(), e.getScreenY());
            HitInfo hitInfo = this.textFlow.hitTest(new Point2D(localEvent.getX() - this.textFlowLayoutX, localEvent.getY() - this.textFlowLayoutY));
            if (hitInfo.getInsertionIndex() >= 0) {
                int dragEnd = this.start + hitInfo.getInsertionIndex();
                ParagraphTile.this.viewModel.setSelection(new Selection(ParagraphTile.this.richTextAreaSkin.mouseDragStart, dragEnd));
                ParagraphTile.this.viewModel.setCaretPosition(dragEnd);
            }
            e.consume();
        }

        void evictUnusedObjects() {
            Set usedFonts = this.textFlow.getChildren().stream().filter(Text.class::isInstance).map(t -> ((Text)t).getFont()).filter(Objects::nonNull).collect(Collectors.toSet());
            ArrayList<Font> cachedFonts = new ArrayList<Font>(ParagraphTile.this.richTextAreaSkin.getFontCache().values());
            cachedFonts.removeAll(usedFonts);
            ParagraphTile.this.richTextAreaSkin.getFontCache().values().removeAll(cachedFonts);
            Set usedImages = this.textFlow.getChildren().stream().filter(ImageView.class::isInstance).map(t -> ((ImageView)t).getImage()).filter(Objects::nonNull).collect(Collectors.toSet());
            ArrayList<Image> cachedImages = new ArrayList<Image>(ParagraphTile.this.richTextAreaSkin.getImageCache().values());
            cachedImages.removeAll(usedImages);
            ParagraphTile.this.richTextAreaSkin.getImageCache().values().removeAll(cachedImages);
        }

        double getCaretY() {
            PathElement[] pathElements = this.textFlow.caretShape(0, false);
            return Stream.of(pathElements).filter(LineTo.class::isInstance).map(LineTo.class::cast).findFirst().map(LineTo::getY).orElse(0.0);
        }

        Font getFont() {
            Text textNode = this.textFlow.getChildren().stream().filter(Text.class::isInstance).map(Text.class::cast).findFirst().orElse(null);
            return Font.font((double)(textNode != null ? textNode.getFont().getSize() : 12.0));
        }

        int getNextRowPosition(double x, boolean down) {
            Bounds caretBounds = this.caretShape.getLayoutBounds();
            double nextRowPos = x < 0.0 ? (down ? caretBounds.getMaxY() + this.textFlow.getLineSpacing() : caretBounds.getMinY() - this.textFlow.getLineSpacing()) : caretBounds.getCenterY();
            double xPos = x < 0.0 ? caretBounds.getMaxX() : x;
            HitInfo hitInfo = this.textFlow.hitTest(new Point2D(xPos, nextRowPos));
            return this.start + hitInfo.getInsertionIndex();
        }

        void updatePrefWidth(double prefWidth) {
            this.textFlow.setPrefWidth(prefWidth);
        }

        boolean hasCaret() {
            return !this.caretShape.getElements().isEmpty();
        }

        private void updateCaretPosition(int caretPosition) {
            this.caretShape.getElements().clear();
            if (!ParagraphTile.this.control.isFocused() && ParagraphTile.this.richTextAreaSkin.dragAndDropStart == -1 || ParagraphTile.this.paragraph == null || caretPosition < this.start || this.getParagraphLimit() <= caretPosition) {
                this.caretTimeline.stop();
                return;
            }
            if (caretPosition < 0 || !ParagraphTile.this.control.isEditable()) {
                this.caretTimeline.stop();
            } else {
                Object[] pathElements = this.textFlow.caretShape(caretPosition - this.start, true);
                if (pathElements.length > 0) {
                    this.caretShape.getElements().addAll(pathElements);
                    if (this.caretShape.getLayoutBounds().getHeight() < 5.0) {
                        double originX = this.caretShape.getElements().stream().filter(MoveTo.class::isInstance).map(MoveTo.class::cast).findFirst().map(MoveTo::getX).orElse(0.0);
                        this.caretShape.getElements().add((Object)new LineTo(originX, 16.0));
                    }
                    ParagraphTile.this.richTextAreaSkin.lastValidCaretPosition = caretPosition;
                    this.caretTimeline.play();
                }
            }
            this.caretShape.setLayoutX(this.textFlowLayoutX);
            this.caretShape.setLayoutY(this.textFlowLayoutY);
        }

        private int getParagraphLimit() {
            int limit = this.end;
            if (ParagraphTile.this.paragraph.equals(ParagraphTile.this.richTextAreaSkin.lastParagraph)) {
                ++limit;
            }
            return limit;
        }

        private void setCaretVisibility(boolean on) {
            if (this.caretShape.getElements().size() > 0) {
                this.caretShape.setOpacity((double)(on ? 1 : 0));
            }
        }

        private void updateSelection(Selection selection) {
            Object[] pathElements;
            this.selectionShape.getElements().clear();
            if (selection != null && selection.isDefined() && this.start <= selection.getEnd() && this.end > selection.getStart() && (pathElements = this.textFlow.rangeShape(Math.max(this.start, selection.getStart()) - this.start, Math.min(this.end, selection.getEnd()) - this.start)).length > 0) {
                this.selectionShape.getElements().setAll(pathElements);
            }
            this.selectionShape.setLayoutX(this.textFlowLayoutX);
            this.selectionShape.setLayoutY(this.textFlowLayoutY);
        }

        private void updateLayer(SetChangeListener.Change<? extends Path> change) {
            if (change.wasAdded()) {
                this.getChildren().add(0, (Object)((Node)change.getElementAdded()));
            } else if (change.wasRemoved()) {
                this.getChildren().remove(change.getElementRemoved());
            }
        }
    }
}

