/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.richtextarea;

import com.gluonhq.richtextarea.IndexRangeColor;
import com.gluonhq.richtextarea.ParagraphTile;
import com.gluonhq.richtextarea.RichTextArea;
import com.gluonhq.richtextarea.RichTextAreaSkin;
import com.gluonhq.richtextarea.model.ImageDecoration;
import com.gluonhq.richtextarea.model.NodeDecoration;
import com.gluonhq.richtextarea.model.Paragraph;
import com.gluonhq.richtextarea.model.TextDecoration;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.IntStream;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.ListCell;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.DragEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseDragEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;

class RichListCell
extends ListCell<Paragraph> {
    private static final Font MIN_LF_FONT = Font.font((double)10.0);
    private final RichTextAreaSkin richTextAreaSkin;
    private final ParagraphTile paragraphTile;

    RichListCell(RichTextAreaSkin richTextAreaSkin) {
        this.richTextAreaSkin = richTextAreaSkin;
        this.setFont(MIN_LF_FONT);
        this.paragraphTile = new ParagraphTile(richTextAreaSkin);
        this.setText(null);
        this.addEventHandler(MouseEvent.DRAG_DETECTED, event -> {
            event.consume();
            this.startFullDrag();
            richTextAreaSkin.anchorIndex = this.getIndex();
        });
        this.addEventHandler(MouseDragEvent.MOUSE_DRAG_OVER, event -> {
            event.consume();
            if (richTextAreaSkin.anchorIndex != -1) {
                this.getParagraphTile().ifPresent(p -> p.mouseDraggedListener((MouseEvent)event));
            }
        });
        this.addEventHandler(MouseEvent.MOUSE_PRESSED, event -> this.getParagraphTile().ifPresentOrElse(p -> p.mousePressedListener((MouseEvent)event), () -> {
            if (!((RichTextArea)richTextAreaSkin.getSkinnable()).isFocused()) {
                ((RichTextArea)richTextAreaSkin.getSkinnable()).requestFocus();
            }
            int textLength = richTextAreaSkin.getViewModel().getTextLength();
            if (richTextAreaSkin.getViewModel().getSelection().isDefined()) {
                if (!event.isShiftDown()) {
                    richTextAreaSkin.getViewModel().clearSelection();
                }
            } else {
                richTextAreaSkin.getViewModel().setCaretPosition(textLength);
            }
            if (richTextAreaSkin.anchorIndex == -1) {
                richTextAreaSkin.mouseDragStart = textLength;
            }
            if (richTextAreaSkin.contextMenu.isShowing()) {
                richTextAreaSkin.contextMenu.hide();
            }
        }));
        this.addEventHandler(MouseEvent.MOUSE_RELEASED, event -> {
            if (richTextAreaSkin.anchorIndex != -1) {
                event.consume();
                richTextAreaSkin.mouseDragStart = -1;
                richTextAreaSkin.anchorIndex = -1;
            }
        });
        this.addEventHandler(DragEvent.DRAG_OVER, de -> {
            if (richTextAreaSkin.dragAndDropStart != -1) {
                this.getParagraphTile().ifPresent(p -> {
                    if (!((RichTextArea)richTextAreaSkin.getSkinnable()).isFocused()) {
                        ((RichTextArea)richTextAreaSkin.getSkinnable()).requestFocus();
                    }
                    p.mousePressedListener(new MouseEvent(de.getSource(), de.getTarget(), MouseEvent.MOUSE_PRESSED, de.getX(), de.getY(), de.getScreenX(), de.getScreenY(), MouseButton.PRIMARY, 1, false, false, false, false, true, false, false, false, false, false, null));
                });
            }
        });
    }

    protected void updateItem(Paragraph item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (item != null && !empty) {
            ArrayList<Node> fragments = new ArrayList<Node>();
            ArrayList<IndexRangeColor> backgroundIndexRanges = new ArrayList<IndexRangeColor>();
            AtomicInteger length = new AtomicInteger();
            ArrayList<Integer> positions = new ArrayList<Integer>();
            positions.add(item.getStart());
            AtomicInteger tp = new AtomicInteger(item.getStart());
            this.richTextAreaSkin.getViewModel().walkFragments((text, decoration) -> {
                if (decoration instanceof TextDecoration && !text.isEmpty()) {
                    if (item.getDecoration().hasTableDecoration()) {
                        AtomicInteger s = new AtomicInteger();
                        IntStream.iterate(text.indexOf(8203), index -> index >= 0, index -> text.indexOf(8203, index + 1)).boxed().forEach(i -> {
                            String tableText = text.substring(s.getAndSet(i + 1), i + 1);
                            Text textNode = this.buildText(tableText, (TextDecoration)decoration);
                            textNode.getProperties().put((Object)"table_separator", (Object)tp.get());
                            fragments.add((Node)textNode);
                            positions.add(tp.addAndGet(tableText.length()));
                        });
                        if (s.get() < text.length()) {
                            String tableText = text.substring(s.get()).replace("\n", "\u200b");
                            Text textNode = this.buildText(tableText, (TextDecoration)decoration);
                            textNode.getProperties().put((Object)"table_separator", (Object)tp.getAndAdd(tableText.length()));
                            fragments.add((Node)textNode);
                            if (text.substring(s.get()).contains("\n")) {
                                positions.add(tp.get());
                            }
                        }
                    } else {
                        Text textNode = this.buildText(text.replace("\n", "\u200b"), (TextDecoration)decoration);
                        fragments.add((Node)textNode);
                        Color background = ((TextDecoration)decoration).getBackground();
                        if (background != Color.TRANSPARENT) {
                            backgroundIndexRanges.add(new IndexRangeColor(length.get(), length.get() + text.length(), background));
                        }
                    }
                    length.addAndGet(text.length());
                } else if (decoration instanceof ImageDecoration) {
                    fragments.add((Node)this.buildImage((ImageDecoration)decoration));
                    length.incrementAndGet();
                    this.richTextAreaSkin.nonTextNodes.incrementAndGet();
                } else if (decoration instanceof NodeDecoration) {
                    fragments.add(((NodeDecoration)decoration).createNode((RichTextArea)this.richTextAreaSkin.getSkinnable(), this.richTextAreaSkin.textFlowPrefWidthProperty.get()));
                    length.incrementAndGet();
                    this.richTextAreaSkin.nonTextNodes.incrementAndGet();
                }
            }, item.getStart(), item.getEnd());
            this.paragraphTile.setParagraph(item, fragments, positions, backgroundIndexRanges);
            this.setGraphic((Node)this.paragraphTile);
            this.paragraphTile.updateLayout();
        } else {
            this.paragraphTile.setParagraph(null, null, null, null);
            this.setGraphic(null);
        }
    }

    private Text buildText(String content, TextDecoration decoration) {
        if ("\n".equals(content)) {
            Text lfText = new Text("\u200b");
            lfText.setFont(MIN_LF_FONT);
            return lfText;
        }
        Objects.requireNonNull(decoration);
        Text text = new Text(Objects.requireNonNull(content));
        text.setFill((Paint)decoration.getForeground());
        text.setStrikethrough(decoration.isStrikethrough().booleanValue());
        text.setUnderline(decoration.isUnderline().booleanValue());
        int hash = Objects.hash(decoration.getFontFamily(), decoration.getFontWeight(), decoration.getFontPosture(), decoration.getFontSize());
        Font font = this.richTextAreaSkin.getFontCache().computeIfAbsent(hash, h -> Font.font((String)decoration.getFontFamily(), (FontWeight)decoration.getFontWeight(), (FontPosture)decoration.getFontPosture(), (double)decoration.getFontSize()));
        text.setFont(font);
        String url = decoration.getURL();
        if (url != null) {
            text.setUnderline(true);
            text.setFill((Paint)Color.BLUE);
            text.setCursor(Cursor.HAND);
            text.addEventHandler(MouseEvent.MOUSE_CLICKED, e -> {
                Consumer<String> consumer;
                Function<Node, Consumer<String>> linkCallbackFactory;
                if (e.getButton() == MouseButton.PRIMARY && (linkCallbackFactory = ((RichTextArea)this.richTextAreaSkin.getSkinnable()).getLinkCallbackFactory()) != null && (consumer = linkCallbackFactory.apply((Node)text)) != null) {
                    consumer.accept(url);
                }
            });
        }
        return text;
    }

    private ImageView buildImage(ImageDecoration imageDecoration) {
        Image image = this.richTextAreaSkin.getImageCache().computeIfAbsent(imageDecoration.getUrl(), Image::new);
        ImageView imageView = new ImageView(image);
        if (imageDecoration.getWidth() > -1 && imageDecoration.getHeight() > -1) {
            imageView.setFitWidth((double)imageDecoration.getWidth());
            imageView.setFitHeight((double)imageDecoration.getHeight());
        } else {
            double width = Math.min(image.getWidth(), this.richTextAreaSkin.textFlowPrefWidthProperty.get() - 10.0);
            imageView.setFitWidth(width);
            imageView.setPreserveRatio(true);
        }
        if (imageDecoration.getLink() != null) {
            imageView.setCursor(Cursor.HAND);
            imageView.addEventHandler(MouseEvent.MOUSE_CLICKED, e -> {
                Consumer<String> consumer;
                Function<Node, Consumer<String>> linkCallbackFactory = ((RichTextArea)this.richTextAreaSkin.getSkinnable()).getLinkCallbackFactory();
                if (linkCallbackFactory != null && (consumer = linkCallbackFactory.apply((Node)imageView)) != null) {
                    consumer.accept(imageDecoration.getLink());
                }
            });
        }
        return imageView;
    }

    void evictUnusedObjects() {
        this.getParagraphTile().ifPresent(ParagraphTile::evictUnusedObjects);
    }

    public void forwardDragEvent(MouseEvent e) {
        this.getParagraphTile().ifPresent(tile -> tile.mouseDraggedListener(e));
    }

    public boolean hasCaret() {
        return this.getParagraphTile().map(ParagraphTile::hasCaret).orElse(false);
    }

    public int getNextRowPosition(double x, boolean down) {
        return this.getParagraphTile().map(tile -> tile.getNextRowPosition(x, down)).orElse(-1);
    }

    private Optional<ParagraphTile> getParagraphTile() {
        if (this.getGraphic() instanceof ParagraphTile) {
            return Optional.of((ParagraphTile)this.getGraphic());
        }
        return Optional.empty();
    }
}

