/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.richtextarea;

import com.gluonhq.richtextarea.RichListCell;
import com.gluonhq.richtextarea.RichTextArea;
import com.gluonhq.richtextarea.Selection;
import com.gluonhq.richtextarea.SmartTimer;
import com.gluonhq.richtextarea.model.Document;
import com.gluonhq.richtextarea.model.ImageDecoration;
import com.gluonhq.richtextarea.model.Paragraph;
import com.gluonhq.richtextarea.model.ParagraphDecoration;
import com.gluonhq.richtextarea.model.PieceTable;
import com.gluonhq.richtextarea.model.Table;
import com.gluonhq.richtextarea.model.TableDecoration;
import com.gluonhq.richtextarea.model.TextBuffer;
import com.gluonhq.richtextarea.model.TextDecoration;
import com.gluonhq.richtextarea.viewmodel.ActionCmd;
import com.gluonhq.richtextarea.viewmodel.ActionCmdFactory;
import com.gluonhq.richtextarea.viewmodel.RichTextAreaViewModel;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.SortedList;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Cursor;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.control.skin.ListViewSkin;
import javafx.scene.control.skin.VirtualFlow;
import javafx.scene.image.Image;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.Region;
import javafx.scene.shape.Path;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import javafx.scene.text.TextAlignment;

public class RichTextAreaSkin
extends SkinBase<RichTextArea> {
    private final RichTextAreaViewModel viewModel = new RichTextAreaViewModel(this::getNextRowPosition);
    private static final ActionCmdFactory ACTION_CMD_FACTORY = new ActionCmdFactory();
    private final Map<KeyCombination, ActionBuilder> INPUT_MAP = Map.ofEntries(Map.entry(new KeyCodeCombination(KeyCode.RIGHT, new KeyCombination.Modifier[]{KeyCombination.SHIFT_ANY, KeyCombination.ALT_ANY, KeyCombination.CONTROL_ANY, KeyCombination.SHORTCUT_ANY}), e -> ACTION_CMD_FACTORY.caretMove(RichTextAreaViewModel.Direction.FORWARD, (KeyEvent)e)), Map.entry(new KeyCodeCombination(KeyCode.LEFT, new KeyCombination.Modifier[]{KeyCombination.SHIFT_ANY, KeyCombination.ALT_ANY, KeyCombination.CONTROL_ANY, KeyCombination.SHORTCUT_ANY}), e -> ACTION_CMD_FACTORY.caretMove(RichTextAreaViewModel.Direction.BACK, (KeyEvent)e)), Map.entry(new KeyCodeCombination(KeyCode.DOWN, new KeyCombination.Modifier[]{KeyCombination.SHIFT_ANY, KeyCombination.ALT_ANY, KeyCombination.SHORTCUT_ANY}), e -> ACTION_CMD_FACTORY.caretMove(RichTextAreaViewModel.Direction.DOWN, (KeyEvent)e)), Map.entry(new KeyCodeCombination(KeyCode.UP, new KeyCombination.Modifier[]{KeyCombination.SHIFT_ANY, KeyCombination.ALT_ANY, KeyCombination.SHORTCUT_ANY}), e -> ACTION_CMD_FACTORY.caretMove(RichTextAreaViewModel.Direction.UP, (KeyEvent)e)), Map.entry(new KeyCodeCombination(KeyCode.HOME, new KeyCombination.Modifier[]{KeyCombination.SHIFT_ANY}), e -> ACTION_CMD_FACTORY.caretMove(RichTextAreaViewModel.Direction.BACK, e.isShiftDown(), false, true)), Map.entry(new KeyCodeCombination(KeyCode.END, new KeyCombination.Modifier[]{KeyCombination.SHIFT_ANY}), e -> ACTION_CMD_FACTORY.caretMove(RichTextAreaViewModel.Direction.FORWARD, e.isShiftDown(), false, true)), Map.entry(new KeyCodeCombination(KeyCode.A, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), e -> ACTION_CMD_FACTORY.selectAll()), Map.entry(new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), e -> ACTION_CMD_FACTORY.copy()), Map.entry(new KeyCodeCombination(KeyCode.X, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), e -> ACTION_CMD_FACTORY.cut()), Map.entry(new KeyCodeCombination(KeyCode.V, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), e -> ACTION_CMD_FACTORY.paste()), Map.entry(new KeyCodeCombination(KeyCode.Z, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), e -> ACTION_CMD_FACTORY.undo()), Map.entry(new KeyCodeCombination(KeyCode.Z, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN, KeyCombination.SHIFT_DOWN}), e -> ACTION_CMD_FACTORY.redo()), Map.entry(new KeyCodeCombination(KeyCode.ENTER, new KeyCombination.Modifier[]{KeyCombination.SHIFT_ANY}), e -> {
        ParagraphDecoration decoration = this.viewModel.getDecorationAtParagraph();
        Paragraph paragraph = this.viewModel.getParagraphWithCaret().orElse(null);
        if (decoration != null && decoration.getGraphicType() != ParagraphDecoration.GraphicType.NONE) {
            int level = decoration.getIndentationLevel();
            if (level > 0 && paragraph != null && this.viewModel.isEmptyParagraph(paragraph)) {
                return ACTION_CMD_FACTORY.decorate(ParagraphDecoration.builder().fromDecoration(decoration).indentationLevel(level - 1).build());
            }
        } else if (paragraph != null && paragraph.getStart() < paragraph.getEnd() && decoration != null && decoration.hasTableDecoration()) {
            int caretPosition = this.viewModel.getCaretPosition();
            Table table = new Table(this.viewModel.getTextBuffer().getText(paragraph.getStart(), paragraph.getEnd()), paragraph.getStart(), decoration.getTableDecoration().getRows(), decoration.getTableDecoration().getColumns());
            int nextCaretAt = table.getCaretAtNextRow(caretPosition, e.isShiftDown() ? RichTextAreaViewModel.Direction.UP : RichTextAreaViewModel.Direction.DOWN);
            this.viewModel.setCaretPosition(nextCaretAt);
            if (nextCaretAt == 0 || nextCaretAt == this.viewModel.getTextLength()) {
                return ACTION_CMD_FACTORY.insertAndDecorate("\n", ParagraphDecoration.builder().presets().build());
            }
            return null;
        }
        return ACTION_CMD_FACTORY.insertText("\n");
    }), Map.entry(new KeyCodeCombination(KeyCode.BACK_SPACE, new KeyCombination.Modifier[]{KeyCombination.SHIFT_ANY}), e -> {
        int caret = this.viewModel.getCaretPosition();
        Paragraph paragraph = this.viewModel.getParagraphWithCaret().orElse(null);
        ParagraphDecoration decoration = this.viewModel.getDecorationAtParagraph();
        if (decoration != null && paragraph != null) {
            if (decoration.hasTableDecoration()) {
                Table table = new Table(this.viewModel.getTextBuffer().getText(paragraph.getStart(), paragraph.getEnd()), paragraph.getStart(), decoration.getTableDecoration().getRows(), decoration.getTableDecoration().getColumns());
                if (table.isCaretAtStartOfCell(caret)) {
                    if (table.isCaretAtEmptyCell(caret)) {
                        return ACTION_CMD_FACTORY.caretMove(RichTextAreaViewModel.Direction.BACK, false, false, false);
                    }
                    return null;
                }
            } else if (paragraph.getStart() == caret) {
                if (decoration.getGraphicType() != ParagraphDecoration.GraphicType.NONE) {
                    return ACTION_CMD_FACTORY.decorate(ParagraphDecoration.builder().fromDecoration(decoration).graphicType(ParagraphDecoration.GraphicType.NONE).build());
                }
                if (decoration.getIndentationLevel() > 0) {
                    return ACTION_CMD_FACTORY.decorate(ParagraphDecoration.builder().fromDecoration(decoration).indentationLevel(decoration.getIndentationLevel() - 1).build());
                }
            }
        }
        return ACTION_CMD_FACTORY.removeText(-1);
    }), Map.entry(new KeyCodeCombination(KeyCode.DELETE, new KeyCombination.Modifier[0]), e -> ACTION_CMD_FACTORY.removeText(0)), Map.entry(new KeyCodeCombination(KeyCode.B, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), e -> {
        TextDecoration decoration = (TextDecoration)this.viewModel.getDecorationAtCaret();
        FontWeight fontWeight = decoration.getFontWeight() == FontWeight.BOLD ? FontWeight.NORMAL : FontWeight.BOLD;
        return ACTION_CMD_FACTORY.decorate(TextDecoration.builder().fromDecoration(decoration).fontWeight(fontWeight).build());
    }), Map.entry(new KeyCodeCombination(KeyCode.I, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), e -> {
        TextDecoration decoration = (TextDecoration)this.viewModel.getDecorationAtCaret();
        FontPosture fontPosture = decoration.getFontPosture() == FontPosture.ITALIC ? FontPosture.REGULAR : FontPosture.ITALIC;
        return ACTION_CMD_FACTORY.decorate(TextDecoration.builder().fromDecoration(decoration).fontPosture(fontPosture).build());
    }), Map.entry(new KeyCodeCombination(KeyCode.TAB, new KeyCombination.Modifier[]{KeyCombination.SHIFT_ANY}), e -> {
        ParagraphDecoration decoration = this.viewModel.getDecorationAtParagraph();
        Paragraph paragraph = this.viewModel.getParagraphWithCaret().orElse(null);
        if (decoration != null && decoration.getGraphicType() != ParagraphDecoration.GraphicType.NONE) {
            int level = Math.max(decoration.getIndentationLevel() + (e.isShiftDown() ? -1 : 1), 0);
            return ACTION_CMD_FACTORY.decorate(ParagraphDecoration.builder().fromDecoration(decoration).indentationLevel(level).build());
        }
        if (decoration != null && decoration.hasTableDecoration() && paragraph != null && paragraph.getStart() < paragraph.getEnd()) {
            int end;
            int caretPosition = this.viewModel.getCaretPosition();
            Table table = new Table(this.viewModel.getTextBuffer().getText(paragraph.getStart(), paragraph.getEnd()), paragraph.getStart(), decoration.getTableDecoration().getRows(), decoration.getTableDecoration().getColumns());
            List<Integer> selectionAtNextCell = table.selectNextCell(caretPosition, e.isShiftDown() ? RichTextAreaViewModel.Direction.BACK : RichTextAreaViewModel.Direction.FORWARD);
            int start = selectionAtNextCell.get(0);
            this.viewModel.clearSelection();
            this.viewModel.setCaretPosition(start);
            if (selectionAtNextCell.size() == 2 && start < (end = selectionAtNextCell.get(1).intValue())) {
                return ACTION_CMD_FACTORY.selectCell(new Selection(start, end));
            }
        }
        return null;
    }));
    private final ParagraphListView paragraphListView;
    private final SortedList<Paragraph> paragraphSortedList = new SortedList(this.viewModel.getParagraphList(), Comparator.comparing(Paragraph::getStart));
    final ContextMenu contextMenu = new ContextMenu();
    private ObservableList<MenuItem> tableCellContextMenuItems;
    private ObservableList<MenuItem> tableContextMenuItems;
    private ObservableList<MenuItem> editableContextMenuItems;
    private ObservableList<MenuItem> nonEditableContextMenuItems;
    private final EventHandler<ContextMenuEvent> contextMenuEventEventHandler = e -> {
        this.contextMenu.show((Node)e.getSource(), e.getScreenX(), e.getScreenY());
        e.consume();
    };
    private final Map<Integer, Font> fontCache = new ConcurrentHashMap<Integer, Font>();
    private final Map<String, Image> imageCache = new ConcurrentHashMap<String, Image>();
    private final SmartTimer objectsCacheEvictionTimer;
    private final Consumer<TextBuffer.Event> textChangeListener = e -> this.refreshTextFlow();
    int lastValidCaretPosition = -1;
    int mouseDragStart = -1;
    int dragAndDropStart = -1;
    int anchorIndex = -1;
    Paragraph lastParagraph = null;
    final DoubleProperty textFlowPrefWidthProperty = new SimpleDoubleProperty(){

        protected void invalidated() {
            if (RichTextAreaSkin.this.paragraphListView != null) {
                Platform.runLater(RichTextAreaSkin.this.paragraphListView::updateLayout);
            }
        }
    };
    private final ChangeListener<Number> controlPrefWidthListener;
    private int nonTextNodesCount;
    AtomicInteger nonTextNodes = new AtomicInteger();
    private final ChangeListener<Document> documentChangeListener = (obs, ov, nv) -> {
        if (ov == null && nv != null) {
            this.dispose();
            this.setup((Document)nv);
            ((RichTextArea)this.getSkinnable()).setDocument((Document)nv);
        } else if (nv != null) {
            ((RichTextArea)this.getSkinnable()).setDocument((Document)nv);
        }
    };
    private final ChangeListener<Number> caretChangeListener;
    private final InvalidationListener focusListener;
    private final EventHandler<DragEvent> dndHandler = this::dndListener;

    protected RichTextAreaSkin(RichTextArea control) {
        super((Control)control);
        this.paragraphListView = new ParagraphListView(control);
        this.paragraphListView.setItems((ObservableList)this.paragraphSortedList);
        this.paragraphListView.setFocusTraversable(false);
        this.getChildren().add((Object)this.paragraphListView);
        this.paragraphListView.setCellFactory(p -> new RichListCell(this));
        this.objectsCacheEvictionTimer = new SmartTimer(this.paragraphListView::evictUnusedObjects, 1000L, 60000L);
        this.controlPrefWidthListener = (obs, ov, nv) -> {
            this.refreshTextFlow();
            this.paragraphListView.updateLayout();
        };
        this.caretChangeListener = (obs, ov, nv) -> this.viewModel.getParagraphWithCaret().ifPresent(paragraph -> Platform.runLater(this.paragraphListView::scrollIfNeeded));
        this.focusListener = o -> this.paragraphListView.updateLayout();
        control.documentProperty().addListener((obs, ov, nv) -> {
            if (this.viewModel.isSaved()) {
                ((RichTextArea)this.getSkinnable()).requestFocus();
                return;
            }
            if (ov != null) {
                this.dispose();
            }
            this.setup((Document)nv);
        });
        try {
            this.setup(control.getDocument());
        }
        catch (Exception exc) {
            exc.printStackTrace();
            Document errorDoc = new Document(control.getDocument().toString());
            this.setup(errorDoc);
        }
    }

    public void dispose() {
        this.viewModel.clearSelection();
        this.viewModel.caretPositionProperty().removeListener(this.caretChangeListener);
        this.viewModel.removeChangeListener(this.textChangeListener);
        this.viewModel.documentProperty().removeListener(this.documentChangeListener);
        this.viewModel.autoSaveProperty().unbind();
        this.lastValidCaretPosition = -1;
        ((RichTextArea)this.getSkinnable()).editableProperty().removeListener(this::editableChangeListener);
        ((RichTextArea)this.getSkinnable()).textLengthProperty.unbind();
        ((RichTextArea)this.getSkinnable()).modifiedProperty.unbind();
        ((RichTextArea)this.getSkinnable()).setOnKeyPressed(null);
        ((RichTextArea)this.getSkinnable()).setOnKeyTyped(null);
        ((RichTextArea)this.getSkinnable()).widthProperty().removeListener(this.controlPrefWidthListener);
        ((RichTextArea)this.getSkinnable()).focusedProperty().removeListener(this.focusListener);
        ((RichTextArea)this.getSkinnable()).removeEventHandler(DragEvent.ANY, this.dndHandler);
        this.contextMenu.getItems().clear();
        this.tableCellContextMenuItems = null;
        this.tableContextMenuItems = null;
        this.editableContextMenuItems = null;
        this.nonEditableContextMenuItems = null;
    }

    public RichTextAreaViewModel getViewModel() {
        return this.viewModel;
    }

    Map<Integer, Font> getFontCache() {
        return this.fontCache;
    }

    Map<String, Image> getImageCache() {
        return this.imageCache;
    }

    private void setup(Document document) {
        if (document == null) {
            return;
        }
        this.viewModel.caretPositionProperty().addListener(this.caretChangeListener);
        this.viewModel.setTextBuffer(new PieceTable(document));
        this.lastValidCaretPosition = document.getCaretPosition();
        this.viewModel.setCaretPosition(this.lastValidCaretPosition);
        this.viewModel.addChangeListener(this.textChangeListener);
        this.viewModel.setDocument(document);
        this.viewModel.documentProperty().addListener(this.documentChangeListener);
        this.viewModel.autoSaveProperty().bind((ObservableValue)((RichTextArea)this.getSkinnable()).autoSaveProperty());
        ((RichTextArea)this.getSkinnable()).textLengthProperty.bind((ObservableValue)this.viewModel.textLengthProperty());
        ((RichTextArea)this.getSkinnable()).modifiedProperty.bind((ObservableValue)this.viewModel.savedProperty().not());
        ((RichTextArea)this.getSkinnable()).setOnContextMenuRequested(this.contextMenuEventEventHandler);
        ((RichTextArea)this.getSkinnable()).editableProperty().addListener(this::editableChangeListener);
        ((RichTextArea)this.getSkinnable()).setOnKeyPressed(this::keyPressedListener);
        ((RichTextArea)this.getSkinnable()).setOnKeyTyped(this::keyTypedListener);
        ((RichTextArea)this.getSkinnable()).widthProperty().addListener(this.controlPrefWidthListener);
        ((RichTextArea)this.getSkinnable()).focusedProperty().addListener(this.focusListener);
        ((RichTextArea)this.getSkinnable()).addEventHandler(DragEvent.ANY, this.dndHandler);
        this.refreshTextFlow();
        this.requestLayout();
        this.editableChangeListener(null);
    }

    private void refreshTextFlow() {
        this.objectsCacheEvictionTimer.pause();
        try {
            this.nonTextNodes.set(0);
            this.viewModel.resetCharacterIterator();
            this.lastParagraph = (Paragraph)this.paragraphSortedList.get(this.paragraphSortedList.size() - 1);
            this.paragraphListView.updateLayout();
            if (this.nonTextNodesCount != this.nonTextNodes.get()) {
                this.requestLayout();
                this.nonTextNodesCount = this.nonTextNodes.get();
            }
            ((RichTextArea)this.getSkinnable()).requestFocus();
        }
        finally {
            this.objectsCacheEvictionTimer.start();
        }
    }

    private void editableChangeListener(Observable o) {
        boolean editable = ((RichTextArea)this.getSkinnable()).isEditable();
        this.viewModel.setEditable(editable);
        this.viewModel.setCaretPosition(editable ? this.lastValidCaretPosition : -1);
        this.paragraphListView.setCursor(editable ? Cursor.TEXT : Cursor.DEFAULT);
        this.populateContextMenu(editable);
        Platform.runLater(this.paragraphListView::scrollIfNeeded);
    }

    private void requestLayout() {
        this.paragraphListView.refresh();
        ((RichTextArea)this.getSkinnable()).requestLayout();
    }

    private int getNextRowPosition(double x, Boolean down) {
        int nextRowPosition;
        block4: {
            int caretPosition;
            ObservableList items;
            block5: {
                items = this.paragraphListView.getItems();
                caretPosition = this.viewModel.getCaretPosition();
                nextRowPosition = Math.min(this.viewModel.getTextLength(), this.paragraphListView.getNextRowPosition(x, down != null && down != false));
                if (down == null) break block4;
                if (down.booleanValue() && nextRowPosition <= caretPosition) break block5;
                if (down.booleanValue() || nextRowPosition < caretPosition) break block4;
            }
            int paragraphWithCaretIndex = items.stream().filter(p -> p.getStart() <= caretPosition && caretPosition < (p.equals(this.lastParagraph) ? p.getEnd() + 1 : p.getEnd())).mapToInt(arg_0 -> items.indexOf(arg_0)).findFirst().orElse(-1);
            if (down.booleanValue()) {
                int nextIndex = Math.min(items.size() - 1, paragraphWithCaretIndex + 1);
                Paragraph nextParagraph = (Paragraph)items.get(nextIndex);
                return items.indexOf((Object)nextParagraph) != paragraphWithCaretIndex ? nextParagraph.getStart() : this.viewModel.getTextLength();
            }
            int prevIndex = Math.max(0, paragraphWithCaretIndex - 1);
            Paragraph prevParagraph = (Paragraph)items.get(prevIndex);
            return items.indexOf((Object)prevParagraph) != paragraphWithCaretIndex ? Math.max(0, prevParagraph.getEnd() - 1) : 0;
        }
        return nextRowPosition;
    }

    private static boolean isPrintableChar(char c) {
        Character.UnicodeBlock changeBlock = Character.UnicodeBlock.of(c);
        return (c == '\n' || c == '\t' || !Character.isISOControl(c)) && !KeyEvent.CHAR_UNDEFINED.equals(String.valueOf(c)) && changeBlock != null && changeBlock != Character.UnicodeBlock.SPECIALS;
    }

    private static boolean isCharOnly(KeyEvent e) {
        char c;
        char c2 = c = e.getCharacter().isEmpty() ? (char)'\u0000' : e.getCharacter().charAt(0);
        return RichTextAreaSkin.isPrintableChar(c) && !e.isControlDown() && !e.isMetaDown() && !e.isAltDown();
    }

    private void execute(ActionCmd action) {
        Objects.requireNonNull(action).apply(this.viewModel);
    }

    private void keyPressedListener(KeyEvent e) {
        for (KeyCombination kc : this.INPUT_MAP.keySet()) {
            if (!kc.match(e)) continue;
            ActionBuilder actionBuilder = this.INPUT_MAP.get(kc);
            ActionCmd actionCmd = (ActionCmd)actionBuilder.apply(e);
            if (actionCmd != null) {
                this.execute(actionCmd);
            }
            e.consume();
            return;
        }
    }

    private void keyTypedListener(KeyEvent e) {
        if (RichTextAreaSkin.isCharOnly(e)) {
            ParagraphDecoration decoration;
            if ("\t".equals(e.getCharacter()) && (decoration = this.viewModel.getDecorationAtParagraph()) != null && (decoration.getGraphicType() != ParagraphDecoration.GraphicType.NONE || decoration.hasTableDecoration())) {
                e.consume();
                return;
            }
            if (this.viewModel.getSelection().isDefined()) {
                this.execute(ACTION_CMD_FACTORY.removeText(-1));
            }
            this.execute(ACTION_CMD_FACTORY.insertText(e.getCharacter()));
            e.consume();
        }
    }

    private void populateContextMenu(boolean isEditable) {
        if (isEditable && this.editableContextMenuItems == null) {
            this.tableCellContextMenuItems = FXCollections.observableArrayList((Object[])new MenuItem[]{this.createMenuItem("Delete cell contents", ACTION_CMD_FACTORY.deleteTableCell()), new SeparatorMenuItem(), this.createMenuItem("Align left", ACTION_CMD_FACTORY.alignTableCell(TextAlignment.LEFT)), this.createMenuItem("Centre", ACTION_CMD_FACTORY.alignTableCell(TextAlignment.CENTER)), this.createMenuItem("Justify", ACTION_CMD_FACTORY.alignTableCell(TextAlignment.JUSTIFY)), this.createMenuItem("Align right", ACTION_CMD_FACTORY.alignTableCell(TextAlignment.RIGHT))});
            Menu tableCellMenu = new Menu("Table Cell");
            tableCellMenu.getItems().addAll(this.tableCellContextMenuItems);
            MenuItem insertTableMenuItem = this.createMenuItem("Insert table", ACTION_CMD_FACTORY.insertTable(new TableDecoration(1, 2)));
            tableCellMenu.disableProperty().bind((ObservableValue)insertTableMenuItem.disableProperty().not());
            this.tableContextMenuItems = FXCollections.observableArrayList((Object[])new MenuItem[]{insertTableMenuItem, this.createMenuItem("Delete table", ACTION_CMD_FACTORY.deleteTable()), new SeparatorMenuItem(), this.createMenuItem("Add column before", ACTION_CMD_FACTORY.insertTableColumnBefore()), this.createMenuItem("Add column after", ACTION_CMD_FACTORY.insertTableColumnAfter()), this.createMenuItem("Delete column", ACTION_CMD_FACTORY.deleteTableColumn()), new SeparatorMenuItem(), this.createMenuItem("Add row above", ACTION_CMD_FACTORY.insertTableRowAbove()), this.createMenuItem("Add row below", ACTION_CMD_FACTORY.insertTableRowBelow()), this.createMenuItem("Delete row", ACTION_CMD_FACTORY.deleteTableRow()), new SeparatorMenuItem(), tableCellMenu});
            Menu tableMenu = new Menu("Table");
            tableMenu.getItems().addAll(this.tableContextMenuItems);
            this.editableContextMenuItems = FXCollections.observableArrayList((Object[])new MenuItem[]{this.createMenuItem("Undo", ACTION_CMD_FACTORY.undo()), this.createMenuItem("Redo", ACTION_CMD_FACTORY.redo()), new SeparatorMenuItem(), this.createMenuItem("Copy", ACTION_CMD_FACTORY.copy()), this.createMenuItem("Cut", ACTION_CMD_FACTORY.cut()), this.createMenuItem("Paste", ACTION_CMD_FACTORY.paste()), new SeparatorMenuItem(), this.createMenuItem("Select All", ACTION_CMD_FACTORY.selectAll()), new SeparatorMenuItem(), tableMenu});
        } else if (!isEditable && this.nonEditableContextMenuItems == null) {
            this.nonEditableContextMenuItems = FXCollections.observableArrayList((Object[])new MenuItem[]{this.createMenuItem("Copy", ACTION_CMD_FACTORY.copy()), new SeparatorMenuItem(), this.createMenuItem("Select All", ACTION_CMD_FACTORY.selectAll())});
        }
        this.contextMenu.getItems().setAll(isEditable ? this.editableContextMenuItems : this.nonEditableContextMenuItems);
    }

    private MenuItem createMenuItem(String text, ActionCmd actionCmd) {
        MenuItem menuItem = new MenuItem(text);
        menuItem.disableProperty().bind((ObservableValue)actionCmd.getDisabledBinding(this.viewModel));
        menuItem.setOnAction(e -> actionCmd.apply(this.viewModel));
        return menuItem;
    }

    private void dndListener(DragEvent dragEvent) {
        if (dragEvent.getEventType() == DragEvent.DRAG_ENTERED) {
            this.dragAndDropStart = 1;
        } else if (dragEvent.getEventType() == DragEvent.DRAG_DONE || dragEvent.getEventType() == DragEvent.DRAG_EXITED) {
            this.dragAndDropStart = -1;
        } else if (dragEvent.getEventType() == DragEvent.DRAG_OVER) {
            Dragboard dragboard = dragEvent.getDragboard();
            if (dragboard.hasImage() || dragboard.hasString() || dragboard.hasUrl() | dragboard.hasFiles()) {
                dragEvent.acceptTransferModes(TransferMode.ANY);
            }
        } else if (dragEvent.getEventType() == DragEvent.DRAG_DROPPED) {
            Dragboard dragboard = dragEvent.getDragboard();
            if (!dragboard.getFiles().isEmpty()) {
                dragboard.getFiles().forEach(file -> {
                    String url = file.toURI().toString();
                    if (url != null && new Image(url).getException() == null) {
                        ACTION_CMD_FACTORY.decorate(new ImageDecoration(url)).apply(this.viewModel);
                    }
                });
            } else if (dragboard.hasUrl()) {
                String url = dragboard.getUrl();
                if (url != null) {
                    if (new Image(url).getException() == null) {
                        ACTION_CMD_FACTORY.decorate(new ImageDecoration(url)).apply(this.viewModel);
                    } else {
                        int caret = this.viewModel.getCaretPosition();
                        ACTION_CMD_FACTORY.insertText(url).apply(this.viewModel);
                        this.viewModel.setSelection(new Selection(caret, caret + url.length()));
                        ACTION_CMD_FACTORY.decorate(TextDecoration.builder().url(url).build()).apply(this.viewModel);
                    }
                }
            } else if (dragboard.hasString()) {
                ACTION_CMD_FACTORY.insertText(dragboard.getString()).apply(this.viewModel);
            }
            this.requestLayout();
            this.dragAndDropStart = -1;
        }
    }

    static interface ActionBuilder
    extends Function<KeyEvent, ActionCmd> {
    }

    private class ParagraphListView
    extends ListView<Paragraph> {
        private final RichVirtualFlow virtualFlow;
        private Group sheet;
        private Region container;

        public ParagraphListView(RichTextArea control) {
            this.virtualFlow = new RichVirtualFlow(control);
            this.getStyleClass().setAll((Object[])new String[]{"paragraph-list-view"});
            this.addEventHandler(MouseEvent.MOUSE_DRAGGED, e -> {
                if (RichTextAreaSkin.this.anchorIndex != -1 && !this.getLayoutBounds().contains(e.getX(), e.getY())) {
                    Point2D listPoint = this.localToScreen(this.getPointInListView((MouseEvent)e));
                    this.getSheet().getChildren().stream().filter(RichListCell.class::isInstance).filter(cell -> cell.getLayoutBounds().contains(cell.screenToLocal(listPoint))).map(RichListCell.class::cast).findFirst().ifPresent(cell -> {
                        Point2D cellPoint = cell.screenToLocal(listPoint);
                        Point2D cellScreenPoint = cell.localToScreen(cellPoint);
                        MouseEvent mouseEvent2 = new MouseEvent(e.getSource(), e.getTarget(), e.getEventType(), cellPoint.getX(), cellPoint.getY(), cellScreenPoint.getX(), cellScreenPoint.getY(), MouseButton.PRIMARY, 1, false, false, false, false, true, false, false, false, false, false, null);
                        cell.forwardDragEvent(mouseEvent2);
                    });
                    double y = e.getY();
                    if (y < 0.0 || y > this.getHeight()) {
                        this.virtualFlow.scrollPixels(y < 0.0 ? y / 10.0 - 1.0 : (y - this.getHeight()) / 10.0 + 1.0);
                    }
                }
            });
            this.addEventHandler(DragEvent.DRAG_OVER, event -> {
                Point2D localEvent;
                if (RichTextAreaSkin.this.dragAndDropStart != -1 && ((localEvent = this.getContainer().screenToLocal(event.getScreenX(), event.getScreenY())).getY() < this.getContainer().getLayoutBounds().getMinY() || localEvent.getY() > this.getContainer().getLayoutBounds().getMaxY())) {
                    this.virtualFlow.scrollPixels(localEvent.getY() <= this.getContainer().getLayoutBounds().getMinY() ? -5 : 5);
                }
            });
        }

        private Point2D getPointInListView(MouseEvent e) {
            double deltaX;
            double iniX = this.getInsets().getLeft();
            double endX = iniX + this.getContainer().getLayoutBounds().getWidth() - this.getInsets().getRight();
            double iniY = this.getInsets().getTop();
            double endY = iniY + this.getContainer().getLayoutBounds().getHeight() - this.getInsets().getBottom();
            double d = e.getX() < iniX ? e.getX() - iniX : (deltaX = e.getX() > endX ? e.getX() - endX : 0.0);
            double deltaY = e.getY() < iniY ? e.getY() - iniY : (e.getY() > endY ? e.getY() - endY : 0.0);
            return new Point2D(e.getX() - deltaX, e.getY() - deltaY);
        }

        private Group getSheet() {
            if (this.sheet == null) {
                this.sheet = (Group)this.virtualFlow.lookup(".sheet");
            }
            return this.sheet;
        }

        private Region getContainer() {
            if (this.container == null) {
                this.container = (Region)this.virtualFlow.lookup(".clipped-container");
            }
            return this.container;
        }

        protected Skin<?> createDefaultSkin() {
            return new ListViewSkin<Paragraph>((ListView)this){

                protected VirtualFlow<ListCell<Paragraph>> createVirtualFlow() {
                    return ParagraphListView.this.virtualFlow;
                }
            };
        }

        void evictUnusedObjects() {
            this.getSheet().getChildren().stream().filter(RichListCell.class::isInstance).map(RichListCell.class::cast).forEach(RichListCell::evictUnusedObjects);
        }

        int getNextRowPosition(double x, boolean down) {
            return this.getSheet().getChildren().stream().filter(RichListCell.class::isInstance).map(RichListCell.class::cast).filter(RichListCell::hasCaret).mapToInt(cell -> cell.getNextRowPosition(x, down)).findFirst().orElse(-1);
        }

        void updateLayout() {
            this.virtualFlow.rebuildCells();
        }

        void scrollIfNeeded() {
            Bounds vfBounds = this.virtualFlow.localToScene(this.virtualFlow.getBoundsInLocal());
            double viewportMinY = vfBounds.getMinY();
            double viewportMaxY = vfBounds.getMaxY();
            this.virtualFlow.lookupAll(".caret").stream().filter(Path.class::isInstance).map(Path.class::cast).filter(path -> !path.getElements().isEmpty()).findFirst().ifPresentOrElse(caret -> {
                Bounds bounds = caret.localToScene(caret.getBoundsInLocal());
                double minY = bounds.getMinY();
                double maxY = bounds.getMaxY();
                if (!(maxY <= viewportMaxY) || !(minY >= viewportMinY)) {
                    this.virtualFlow.scrollPixels(maxY > viewportMaxY ? maxY - viewportMaxY + 1.0 : minY - viewportMinY - 1.0);
                }
            }, () -> RichTextAreaSkin.this.viewModel.getParagraphWithCaret().ifPresent(arg_0 -> ((ParagraphListView)this).scrollTo(arg_0)));
        }
    }

    private class RichVirtualFlow
    extends VirtualFlow<ListCell<Paragraph>> {
        RichVirtualFlow(RichTextArea control) {
            ReadOnlyObjectProperty clippedBounds = this.lookup(".clipped-container").layoutBoundsProperty();
            RichTextAreaSkin.this.textFlowPrefWidthProperty.bind((ObservableValue)Bindings.createDoubleBinding(() -> control.getContentAreaWidth() > 0.0 ? control.getContentAreaWidth() : (((Bounds)clippedBounds.get()).getWidth() > 0.0 ? ((Bounds)clippedBounds.get()).getWidth() - 10.0 : -1.0), (Observable[])new Observable[]{control.contentAreaWidthProperty(), clippedBounds}));
        }

        protected void rebuildCells() {
            super.rebuildCells();
        }
    }
}

