/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.richtextarea;

import java.util.Objects;

public class Selection {
    public static Selection UNDEFINED = new Selection(-1, -1);
    private final int start;
    private final int end;

    public Selection(int start, int end) {
        if (start < 0 || end < 0 || start == end) {
            this.start = -1;
            this.end = -1;
        } else {
            this.start = Math.min(start, end);
            this.end = Math.max(start, end);
        }
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public int getLength() {
        return this.end - this.start;
    }

    public boolean isDefined() {
        return !UNDEFINED.equals(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Selection selection = (Selection)o;
        return this.start == selection.start && this.end == selection.end;
    }

    public int hashCode() {
        return Objects.hash(this.start, this.end);
    }

    public String toString() {
        return "Selection {start=" + this.start + ", end=" + this.end + '}';
    }
}

