/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.richtextarea;

import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;

class SmartTimer {
    private Timer timer;
    private final Runnable task;
    private final long delay;
    private final long period;

    public SmartTimer(Runnable task, long delay, long period) {
        this.task = Objects.requireNonNull(task);
        this.delay = delay;
        this.period = period;
    }

    public void pause() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    public void start() {
        if (this.timer == null) {
            this.timer = new Timer(true);
            TimerTask timerTask = new TimerTask(){

                @Override
                public void run() {
                    SmartTimer.this.task.run();
                }
            };
            this.timer.scheduleAtFixedRate(timerTask, this.delay, this.period);
        }
    }
}

