/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.richtextarea.action;

import com.gluonhq.richtextarea.RichTextArea;
import com.gluonhq.richtextarea.action.Action;
import com.gluonhq.richtextarea.action.BasicAction;
import com.gluonhq.richtextarea.model.Decoration;
import com.gluonhq.richtextarea.model.Document;
import com.gluonhq.richtextarea.model.TableDecoration;
import com.gluonhq.richtextarea.viewmodel.ActionCmdFactory;

public class ActionFactory {
    private static final ActionCmdFactory ACTION_CMD_FACTORY = new ActionCmdFactory();
    private final RichTextArea control;
    private Action undo;
    private Action redo;
    private Action copy;
    private Action cut;
    private Action paste;
    private Action newDocument;
    private Action save;

    public ActionFactory(RichTextArea control) {
        this.control = control;
    }

    public Action undo() {
        if (this.undo == null) {
            this.undo = new BasicAction(this.control, action -> ACTION_CMD_FACTORY.undo());
        }
        return this.undo;
    }

    public Action redo() {
        if (this.redo == null) {
            this.redo = new BasicAction(this.control, action -> ACTION_CMD_FACTORY.redo());
        }
        return this.redo;
    }

    public Action copy() {
        if (this.copy == null) {
            this.copy = new BasicAction(this.control, action -> ACTION_CMD_FACTORY.copy());
        }
        return this.copy;
    }

    public Action cut() {
        if (this.cut == null) {
            this.cut = new BasicAction(this.control, action -> ACTION_CMD_FACTORY.cut());
        }
        return this.cut;
    }

    public Action paste() {
        if (this.paste == null) {
            this.paste = new BasicAction(this.control, action -> ACTION_CMD_FACTORY.paste());
        }
        return this.paste;
    }

    public Action newDocument() {
        if (this.newDocument == null) {
            this.newDocument = new BasicAction(this.control, action -> ACTION_CMD_FACTORY.newDocument());
        }
        return this.newDocument;
    }

    public Action open(Document document) {
        return new BasicAction(this.control, action -> ACTION_CMD_FACTORY.open(document));
    }

    public Action save() {
        if (this.save == null) {
            this.save = new BasicAction(this.control, action -> ACTION_CMD_FACTORY.save());
        }
        return this.save;
    }

    public Action insertTable(TableDecoration tableDecoration) {
        return new BasicAction(this.control, action -> ACTION_CMD_FACTORY.insertTable(tableDecoration));
    }

    public Action decorate(Decoration ... decorations) {
        return new BasicAction(this.control, action -> ACTION_CMD_FACTORY.decorate(decorations));
    }
}

