/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.richtextarea.action;

import com.gluonhq.richtextarea.RichTextArea;
import com.gluonhq.richtextarea.RichTextAreaSkin;
import com.gluonhq.richtextarea.action.Action;
import com.gluonhq.richtextarea.viewmodel.ActionCmd;
import com.gluonhq.richtextarea.viewmodel.RichTextAreaViewModel;
import java.util.Objects;
import java.util.function.Function;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.scene.control.Skin;

class BasicAction
implements Action {
    private RichTextAreaViewModel viewModel;
    private final Function<Action, ActionCmd> actionCmdFunction;
    private final BooleanProperty disabledImplProperty = new SimpleBooleanProperty((Object)this, "disabledImpl", false);

    public BasicAction(final RichTextArea control, Function<Action, ActionCmd> actionCmdFunction) {
        this.actionCmdFunction = Objects.requireNonNull(actionCmdFunction);
        if (control.getSkin() != null) {
            this.initialize(control.getSkin());
        } else {
            control.skinProperty().addListener(new InvalidationListener(){

                public void invalidated(Observable observable) {
                    if (control.getSkin() != null) {
                        BasicAction.this.initialize(control.getSkin());
                        control.skinProperty().removeListener((InvalidationListener)this);
                    }
                }
            });
        }
    }

    private void initialize(Skin<?> skin) {
        if (!(skin instanceof RichTextAreaSkin)) {
            return;
        }
        this.viewModel = ((RichTextAreaSkin)skin).getViewModel();
        BooleanBinding binding = this.getActionCmd().getDisabledBinding(this.viewModel);
        if (binding != null) {
            this.disabledImplProperty.bind((ObservableValue)binding);
        }
    }

    private ActionCmd getActionCmd() {
        return this.actionCmdFunction.apply(this);
    }

    @Override
    public void execute(ActionEvent event) {
        Platform.runLater(() -> this.getActionCmd().apply(this.viewModel));
    }

    @Override
    public ReadOnlyBooleanProperty disabledProperty() {
        return this.disabledImplProperty;
    }
}

