/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.richtextarea.action;

import com.gluonhq.richtextarea.RichTextArea;
import com.gluonhq.richtextarea.action.DecorateAction;
import com.gluonhq.richtextarea.model.ParagraphDecoration;
import java.util.function.BiFunction;
import java.util.function.Function;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ChangeListener;

public class ParagraphDecorateAction<T>
extends DecorateAction<T> {
    private ChangeListener<T> valuePropertyChangeListener;
    private ChangeListener<ParagraphDecoration> decorationChangeListener;
    private final Function<ParagraphDecoration, T> function;
    private final BiFunction<ParagraphDecoration.Builder, T, ParagraphDecoration> builderTFunction;

    public ParagraphDecorateAction(RichTextArea control, ObjectProperty<T> valueProperty, Function<ParagraphDecoration, T> valueFunction, BiFunction<ParagraphDecoration.Builder, T, ParagraphDecoration> builderTFunction) {
        super(control, valueProperty);
        this.function = valueFunction;
        this.builderTFunction = builderTFunction;
    }

    @Override
    protected void bind() {
        this.valuePropertyChangeListener = (obs, ov, nv) -> {
            if (nv != null && !this.updating) {
                this.updating = true;
                ParagraphDecoration.Builder builder = ParagraphDecoration.builder();
                if (!this.viewModel.getSelection().isDefined() && this.viewModel.getDecorationAtParagraph() != null) {
                    builder = builder.fromDecoration(this.viewModel.getDecorationAtParagraph());
                }
                ParagraphDecoration newParagraphDecoration = this.builderTFunction.apply(builder, (ParagraphDecoration.Builder)nv);
                Platform.runLater(() -> {
                    ACTION_CMD_FACTORY.decorate(newParagraphDecoration).apply(this.viewModel);
                    this.control.requestFocus();
                });
                this.updating = false;
            }
        };
        this.valueProperty.addListener(this.valuePropertyChangeListener);
        this.decorationChangeListener = (obs, ov, nv) -> {
            T newValue;
            if (!(this.updating || nv.equals(ov) || (newValue = this.function.apply((ParagraphDecoration)nv)) == null || ov != null && newValue.equals(this.function.apply((ParagraphDecoration)ov)))) {
                this.updating = true;
                this.valueProperty.set(newValue);
                this.updating = false;
            }
        };
        this.viewModel.decorationAtParagraphProperty().addListener(this.decorationChangeListener);
    }

    @Override
    protected void unbind() {
        this.valueProperty.removeListener(this.valuePropertyChangeListener);
        this.viewModel.decorationAtParagraphProperty().removeListener(this.decorationChangeListener);
    }
}

