/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.richtextarea.action;

import com.gluonhq.richtextarea.RichTextArea;
import com.gluonhq.richtextarea.action.DecorateAction;
import com.gluonhq.richtextarea.model.Decoration;
import com.gluonhq.richtextarea.model.TextDecoration;
import java.util.function.BiFunction;
import java.util.function.Function;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ChangeListener;

public class TextDecorateAction<T>
extends DecorateAction<T> {
    private ChangeListener<T> valuePropertyChangeListener;
    private ChangeListener<Decoration> decorationChangeListener;
    private final Function<TextDecoration, T> function;
    private final BiFunction<TextDecoration.Builder, T, TextDecoration> builderTFunction;

    public TextDecorateAction(RichTextArea control, ObjectProperty<T> valueProperty, Function<TextDecoration, T> valueFunction, BiFunction<TextDecoration.Builder, T, TextDecoration> builderTFunction) {
        super(control, valueProperty);
        this.function = valueFunction;
        this.builderTFunction = builderTFunction;
    }

    @Override
    protected void bind() {
        this.valuePropertyChangeListener = (obs, ov, nv) -> {
            if (nv != null && !this.updating) {
                this.updating = true;
                TextDecoration.Builder builder = TextDecoration.builder();
                Decoration decoration = this.viewModel.getDecorationAtCaret();
                if (!this.viewModel.getSelection().isDefined() && decoration instanceof TextDecoration) {
                    builder = builder.fromDecoration((TextDecoration)decoration);
                }
                TextDecoration newTextDecoration = this.builderTFunction.apply(builder, (TextDecoration.Builder)nv);
                Platform.runLater(() -> {
                    ACTION_CMD_FACTORY.decorate(newTextDecoration).apply(this.viewModel);
                    this.control.requestFocus();
                });
                this.updating = false;
            }
        };
        this.valueProperty.addListener(this.valuePropertyChangeListener);
        this.decorationChangeListener = (obs, ov, nv) -> {
            T newValue;
            if (!this.updating && nv instanceof TextDecoration && ov instanceof TextDecoration && !nv.equals(ov) && (newValue = this.function.apply((TextDecoration)nv)) != null && !newValue.equals(this.function.apply((TextDecoration)ov))) {
                this.updating = true;
                this.valueProperty.set(newValue);
                this.updating = false;
            }
        };
        this.viewModel.decorationAtCaretProperty().addListener(this.decorationChangeListener);
    }

    @Override
    protected void unbind() {
        this.valueProperty.removeListener(this.valuePropertyChangeListener);
        this.viewModel.decorationAtCaretProperty().removeListener(this.decorationChangeListener);
    }
}

