/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.richtextarea.model;

import com.gluonhq.richtextarea.model.TextBuffer;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyIntegerWrapper;

public abstract class AbstractTextBuffer
implements TextBuffer {
    private final Set<Consumer<TextBuffer.Event>> listeners = new HashSet<Consumer<TextBuffer.Event>>();
    final ReadOnlyIntegerWrapper textLengthProperty = new ReadOnlyIntegerWrapper((Object)this, "textLength");

    @Override
    public ReadOnlyIntegerProperty textLengthProperty() {
        return this.textLengthProperty.getReadOnlyProperty();
    }

    @Override
    public int getTextLength() {
        return this.textLengthProperty.get();
    }

    @Override
    public final void addChangeListener(Consumer<TextBuffer.Event> listener) {
        this.listeners.add(Objects.requireNonNull(listener));
    }

    @Override
    public final void removeChangeListener(Consumer<TextBuffer.Event> listener) {
        this.listeners.remove(Objects.requireNonNull(listener));
    }

    protected void fire(TextBuffer.Event event) {
        this.listeners.forEach(l -> l.accept(event));
    }
}

