/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.richtextarea.model;

import com.gluonhq.richtextarea.model.AbstractPTCmd;
import com.gluonhq.richtextarea.model.Piece;
import com.gluonhq.richtextarea.model.PieceTable;
import com.gluonhq.richtextarea.model.TextBuffer;
import java.util.Objects;

class AppendCmd
extends AbstractPTCmd {
    private final String text;
    private Piece newPiece;
    private boolean execSuccess = false;

    AppendCmd(String text) {
        this.text = Objects.requireNonNull(text);
    }

    @Override
    protected void doUndo(PieceTable pt) {
        if (this.execSuccess) {
            pt.pieces.remove(this.newPiece);
            pt.fire(new TextBuffer.DeleteEvent(pt.getTextLength() - this.text.length(), this.text.length()));
            pt.textLengthProperty.set(pt.getTextLength() - this.text.length());
        }
    }

    @Override
    protected void doRedo(PieceTable pt) {
        if (!this.text.isEmpty()) {
            int pos = pt.getTextLength();
            this.newPiece = pt.appendTextInternal(this.text, pt.decorationAtCaret != null ? pt.decorationAtCaret : pt.previousPieceDecoration(pt.pieces.size()), pt.getParagraphDecorationAtCaret(pos) != null ? pt.getParagraphDecorationAtCaret(pos) : pt.previousPieceParagraphDecoration(pt.pieces.size()));
            pt.pieces.add(this.newPiece);
            pt.fire(new TextBuffer.InsertEvent(this.text, pos));
            this.execSuccess = true;
        }
    }

    public String toString() {
        return "AppendCmd[\"" + this.text + "\"]";
    }
}

