/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.richtextarea.model;

import com.gluonhq.richtextarea.model.ParagraphDecoration;
import com.gluonhq.richtextarea.model.Piece;
import com.gluonhq.richtextarea.model.PieceTable;
import com.gluonhq.richtextarea.model.TextBuffer;
import com.gluonhq.richtextarea.undo.AbstractCommand;
import java.util.ArrayList;
import java.util.Collection;

class DeleteCmd
extends AbstractCommand<PieceTable> {
    private final int deletePosition;
    private int length;
    private boolean execSuccess = false;
    private int pieceIndex = -1;
    private Collection<Piece> newPieces;
    private Collection<Piece> oldPieces;

    DeleteCmd(int deletePosition, int length) {
        this.deletePosition = deletePosition;
        this.length = length;
    }

    @Override
    protected void doUndo(PieceTable pt) {
        if (this.execSuccess) {
            pt.pieces.addAll(this.pieceIndex, this.oldPieces);
            pt.pieces.removeAll(this.newPieces);
            String text = this.oldPieces.stream().map(Piece::getText).reduce("", (id, s) -> String.valueOf(id) + s);
            pt.fire(new TextBuffer.InsertEvent(text, this.deletePosition));
            pt.textLengthProperty.set(pt.getTextLength() + this.length);
        }
    }

    @Override
    protected void doRedo(PieceTable pt) {
        if (this.deletePosition < 0 || this.deletePosition > pt.getTextLength()) {
            throw new IllegalArgumentException("Position " + this.deletePosition + " is outside of text bounds [0," + pt.getTextLength() + "]");
        }
        if (this.deletePosition + this.length >= pt.getTextLength()) {
            this.length = pt.getTextLength() - this.deletePosition;
        }
        int endPosition = this.deletePosition + this.length;
        int[] startPieceIndex = new int[1];
        ArrayList<Piece> additions = new ArrayList<Piece>();
        ArrayList<Piece> removals = new ArrayList<Piece>();
        pt.walkPieces((piece, pieceIndex, textPosition) -> {
            if (PieceTable.inRange(this.deletePosition, textPosition, piece.length)) {
                int pieceOffset = this.deletePosition - textPosition;
                nArray[0] = pieceIndex;
                additions.add(piece.pieceBefore(pieceOffset));
                removals.add(piece);
            }
            if (!additions.isEmpty()) {
                if (!removals.contains(piece)) {
                    removals.add(piece);
                }
                if (PieceTable.inRange(endPosition, textPosition, piece.length)) {
                    int offset = endPosition - textPosition;
                    ParagraphDecoration paragraphDecoration = ((Piece)additions.get(additions.size() - 1)).getParagraphDecoration();
                    Piece nextPiece = piece.copy(piece.start + offset, piece.length - offset, piece.decoration, paragraphDecoration == null ? piece.paragraphDecoration : paragraphDecoration);
                    additions.add(nextPiece);
                    return true;
                }
            }
            return false;
        });
        this.newPieces = PieceTable.normalize(additions);
        this.oldPieces = removals;
        if (this.newPieces.size() > 0 || this.oldPieces.size() > 0) {
            this.pieceIndex = startPieceIndex[0];
            pt.pieces.addAll(this.pieceIndex, this.newPieces);
            pt.pieces.removeAll(this.oldPieces);
            pt.textLengthProperty.set(pt.getTextLength() - this.length);
            pt.fire(new TextBuffer.DeleteEvent(this.deletePosition, this.length));
            this.execSuccess = true;
        }
    }

    public String toString() {
        return "DeleteCmd[" + this.deletePosition + " x " + this.length + "]";
    }
}

