/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.richtextarea.model;

import com.gluonhq.richtextarea.model.DecorationModel;
import com.gluonhq.richtextarea.model.ParagraphDecoration;
import com.gluonhq.richtextarea.model.TextDecoration;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class Document {
    private final String text;
    private final List<DecorationModel> decorationList;
    private final int caretPosition;

    public Document() {
        this("");
    }

    public Document(String text) {
        this(text, 0);
    }

    public Document(String text, int caretPosition) {
        this(text, List.of(new DecorationModel(0, text.length(), TextDecoration.builder().presets().build(), ParagraphDecoration.builder().presets().build())), caretPosition);
    }

    public Document(String text, List<DecorationModel> decorationList, int caretPosition) {
        this.text = text;
        this.decorationList = decorationList;
        this.caretPosition = caretPosition;
    }

    public String getText() {
        return this.text;
    }

    public List<DecorationModel> getDecorations() {
        return this.decorationList;
    }

    public int getCaretPosition() {
        return this.caretPosition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Document document = (Document)o;
        return Objects.equals(this.text, document.text) && Objects.equals(this.decorationList, document.decorationList);
    }

    public int hashCode() {
        return Objects.hash(this.text, this.decorationList, this.caretPosition);
    }

    public String toString() {
        return "Document{text='" + this.text.replaceAll("\n", "<n>").replaceAll("\u200b", "<a>") + '\'' + ", decorationList=" + (this.decorationList == null ? "null" : "{" + this.decorationList.stream().map(decorationModel -> " - " + decorationModel.toString()).collect(Collectors.joining("\n", "\n", ""))) + "\n}, caretPosition=" + this.caretPosition + '}';
    }
}

