/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.richtextarea.model;

import com.gluonhq.richtextarea.model.ImageDecoration;
import com.gluonhq.richtextarea.model.ParagraphDecoration;
import com.gluonhq.richtextarea.model.Piece;
import com.gluonhq.richtextarea.model.PieceTable;
import com.gluonhq.richtextarea.model.TextBuffer;
import com.gluonhq.richtextarea.undo.AbstractCommand;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

class ImageDecorateCmd
extends AbstractCommand<PieceTable> {
    private final ImageDecoration decoration;
    private final int insertPosition;
    private boolean execSuccess = false;
    private Piece newPiece;
    private Piece oldPiece;
    private int opPieceIndex;
    private Collection<Piece> newPieces = new ArrayList<Piece>();

    ImageDecorateCmd(ImageDecoration decoration, int insertPosition) {
        this.decoration = decoration;
        this.insertPosition = insertPosition;
    }

    @Override
    protected void doUndo(PieceTable pt) {
        if (this.execSuccess) {
            if (this.newPiece != null) {
                pt.pieces.remove(this.newPiece);
                pt.fire(new TextBuffer.DeleteEvent(pt.getTextLength() - 1, 1));
            } else {
                pt.pieces.add(this.opPieceIndex, this.oldPiece);
                pt.pieces.removeAll(this.newPieces);
                pt.fire(new TextBuffer.DeleteEvent(this.insertPosition, 1));
            }
            pt.textLengthProperty.set(pt.getTextLength() - 1);
        }
    }

    @Override
    protected void doRedo(PieceTable pt) {
        ParagraphDecoration paragraphDecoration;
        if (this.insertPosition < 0 || this.insertPosition > pt.getTextLength()) {
            throw new IllegalArgumentException("Position " + this.insertPosition + " is outside of text bounds [0, " + pt.getTextLength() + "]");
        }
        ParagraphDecoration paragraphDecoration2 = paragraphDecoration = pt.getParagraphDecorationAtCaret(this.insertPosition) != null ? pt.getParagraphDecorationAtCaret(this.insertPosition) : pt.previousPieceParagraphDecoration(this.insertPosition);
        if (this.insertPosition == pt.getTextLength()) {
            int pos = pt.getTextLength();
            this.newPiece = pt.appendTextInternal("\u200b", this.decoration, paragraphDecoration);
            pt.pieces.add(this.newPiece);
            pt.fire(new TextBuffer.InsertEvent("\u200b", pos));
            this.execSuccess = true;
        } else {
            pt.walkPieces((piece, pieceIndex, textPosition) -> {
                if (PieceTable.inRange(this.insertPosition, textPosition, piece.length)) {
                    int pieceOffset = this.insertPosition - textPosition;
                    this.newPieces = PieceTable.normalize(List.of(piece.pieceBefore(pieceOffset), pt.appendTextInternal("\u200b", this.decoration, paragraphDecoration), piece.pieceFrom(pieceOffset)));
                    this.oldPiece = piece;
                    pieceTable.pieces.addAll(pieceIndex, this.newPieces);
                    pieceTable.pieces.remove(this.oldPiece);
                    this.opPieceIndex = pieceIndex;
                    pt.fire(new TextBuffer.InsertEvent("\u200b", this.insertPosition));
                    this.execSuccess = true;
                    return true;
                }
                return false;
            });
        }
    }

    public String toString() {
        return "ImageDecorateCmd[" + this.decoration + " at " + this.insertPosition + "]";
    }
}

